/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript.runtime;

import java.util.Map;
import net.entframework.kernel.db.generator.plugin.web.freemarker.FreemarkerTemplateEngine;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class TemplateGeneratedFile
extends GeneratedFile {
    private final TopLevelClass topLevelClass;
    private final String fileEncoding = "utf-8";
    private final Map<String, Object> data;
    private final String templatePath;
    private final String fileName;
    private final String fileExt;

    public TemplateGeneratedFile(TopLevelClass topLevelClass, String targetProject, Map<String, Object> data, String templatePath, String fileName, String fileExt) {
        super(targetProject);
        this.topLevelClass = topLevelClass;
        this.data = data;
        this.templatePath = templatePath;
        this.fileName = fileName;
        this.fileExt = fileExt;
    }

    public String getFormattedContent() {
        try {
            return FreemarkerTemplateEngine.process(this.data, this.templatePath);
        }
        catch (Exception e) {
            System.out.println("error when process : " + this.templatePath);
            e.printStackTrace();
            return "error generate content";
        }
    }

    public String getFileName() {
        String shortName = this.topLevelClass.getType().getShortNameWithoutTypeArguments();
        String camelCaseName = JavaBeansUtil.convertCamelCase((String)shortName, (String)"-");
        if (StringUtils.isNotEmpty((CharSequence)this.fileName)) {
            return String.format(this.fileName, camelCaseName) + this.fileExt;
        }
        return camelCaseName + this.fileExt;
    }

    public String getTargetPackage() {
        return this.topLevelClass.getType().getPackageName();
    }

    public CompilationUnit getCompilationUnit() {
        return this.topLevelClass;
    }

    public boolean isMergeable() {
        return false;
    }

    public String getFileEncoding() {
        return "utf-8";
    }

    public WriteMode getWriteMode() {
        return this.topLevelClass.getWriteMode();
    }
}

