/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript.runtime;

import net.entframework.kernel.db.generator.typescript.runtime.FullyQualifiedTypescriptType;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;

public class GeneratedTypescriptFile
extends GeneratedJavaFile {
    private final CompilationUnit compilationUnit;
    private final String fileEncoding;
    private final JavaFormatter javaFormatter;

    public GeneratedTypescriptFile(CompilationUnit compilationUnit, String targetProject, String fileEncoding, JavaFormatter javaFormatter, String projectAlias) {
        super(compilationUnit, targetProject, fileEncoding, javaFormatter);
        this.compilationUnit = compilationUnit;
        this.fileEncoding = fileEncoding;
        this.javaFormatter = javaFormatter;
    }

    public GeneratedTypescriptFile(CompilationUnit compilationUnit, String targetProject, String fileEncoding, JavaFormatter javaFormatter) {
        super(compilationUnit, targetProject, fileEncoding, javaFormatter);
        this.compilationUnit = compilationUnit;
        this.fileEncoding = fileEncoding;
        this.javaFormatter = javaFormatter;
    }

    public String getFormattedContent() {
        return this.javaFormatter.getFormattedContent(this.compilationUnit);
    }

    public String getFileName() {
        FullyQualifiedTypescriptType fqtt = (FullyQualifiedTypescriptType)this.compilationUnit.getType();
        String shortName = fqtt.getFileName();
        return shortName + ".ts";
    }

    public String getTargetPackage() {
        if (this.compilationUnit.getType() instanceof FullyQualifiedTypescriptType) {
            return StringUtils.substringBeforeLast((String)this.compilationUnit.getType().getPackageName(), (String)".");
        }
        return this.compilationUnit.getType().getPackageName();
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public boolean isMergeable() {
        return false;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public WriteMode getWriteMode() {
        return this.compilationUnit.getWriteMode();
    }
}

