/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.entframework.kernel.db.generator.typescript.render.FieldRenderer;
import net.entframework.kernel.db.generator.typescript.render.InitializationBlockRenderer;
import net.entframework.kernel.db.generator.typescript.render.InnerClassRenderer;
import net.entframework.kernel.db.generator.typescript.render.InnerEnumRenderer;
import net.entframework.kernel.db.generator.typescript.render.InnerInterfaceRenderer;
import net.entframework.kernel.db.generator.typescript.render.MethodRenderer;
import net.entframework.kernel.db.generator.typescript.render.TypeParameterRenderer;
import net.entframework.kernel.db.generator.typescript.render.TypescriptImport;
import net.entframework.kernel.db.generator.typescript.runtime.FullyQualifiedTypescriptType;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InitializationBlock;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.InnerInterface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TypeParameter;
import org.mybatis.generator.internal.util.CustomCollectors;

public class RenderingUtilities {
    public static final String JAVA_INDENT = "  ";
    private static final TypeParameterRenderer typeParameterRenderer = new TypeParameterRenderer();
    private static final FieldRenderer fieldRenderer = new FieldRenderer();
    private static final InitializationBlockRenderer initializationBlockRenderer = new InitializationBlockRenderer();
    private static final MethodRenderer methodRenderer = new MethodRenderer();
    private static final InnerClassRenderer innerClassRenderer = new InnerClassRenderer();
    private static final InnerInterfaceRenderer innerInterfaceRenderer = new InnerInterfaceRenderer();
    private static final InnerEnumRenderer innerEnumRenderer = new InnerEnumRenderer();

    private RenderingUtilities() {
    }

    public static String renderTypeParameters(List<TypeParameter> typeParameters, CompilationUnit compilationUnit) {
        return (String)typeParameters.stream().map(tp -> typeParameterRenderer.render((TypeParameter)tp, compilationUnit)).collect(CustomCollectors.joining((CharSequence)", ", (CharSequence)"<", (CharSequence)"> "));
    }

    public static List<String> renderFields(List<Field> fields, CompilationUnit compilationUnit) {
        return fields.stream().flatMap(f -> RenderingUtilities.renderField(f, compilationUnit)).collect(Collectors.toList());
    }

    private static Stream<String> renderField(Field field, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(fieldRenderer.render(field, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    public static List<String> renderInitializationBlocks(List<InitializationBlock> initializationBlocks) {
        return initializationBlocks.stream().flatMap(RenderingUtilities::renderInitializationBlock).collect(Collectors.toList());
    }

    private static Stream<String> renderInitializationBlock(InitializationBlock initializationBlock) {
        return RenderingUtilities.addEmptyLine(initializationBlockRenderer.render(initializationBlock).stream());
    }

    public static List<String> renderClassOrEnumMethods(List<Method> methods, CompilationUnit compilationUnit) {
        return methods.stream().flatMap(m -> RenderingUtilities.renderMethodNoIndent(m, false, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInterfaceMethods(List<Method> methods, CompilationUnit compilationUnit) {
        return methods.stream().flatMap(m -> RenderingUtilities.renderMethod(m, true, compilationUnit)).collect(Collectors.toList());
    }

    private static Stream<String> renderMethod(Method method, boolean inInterface, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(methodRenderer.render(method, inInterface, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    private static Stream<String> renderMethodNoIndent(Method method, boolean inInterface, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(methodRenderer.render(method, inInterface, compilationUnit).stream());
    }

    private static Stream<String> addEmptyLine(Stream<String> in) {
        return Stream.of(in, Stream.of("")).flatMap(Function.identity());
    }

    public static List<String> renderInnerClasses(List<InnerClass> innerClasses, CompilationUnit compilationUnit) {
        return innerClasses.stream().flatMap(ic -> RenderingUtilities.renderInnerClass(ic, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInnerClassNoIndent(InnerClass innerClass, CompilationUnit compilationUnit) {
        return innerClassRenderer.render(innerClass, compilationUnit);
    }

    private static Stream<String> renderInnerClass(InnerClass innerClass, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(innerClassRenderer.render(innerClass, compilationUnit).stream());
    }

    public static List<String> renderInnerInterfaces(List<InnerInterface> innerInterfaces, CompilationUnit compilationUnit) {
        return innerInterfaces.stream().flatMap(ii -> RenderingUtilities.renderInnerInterface(ii, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInnerInterfaceNoIndent(InnerInterface innerInterface, CompilationUnit compilationUnit) {
        return innerInterfaceRenderer.render(innerInterface, compilationUnit);
    }

    private static Stream<String> renderInnerInterface(InnerInterface innerInterface, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(innerInterfaceRenderer.render(innerInterface, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    public static List<String> renderInnerEnums(List<InnerEnum> innerEnums, CompilationUnit compilationUnit) {
        return innerEnums.stream().flatMap(ie -> RenderingUtilities.renderInnerEnum(ie, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInnerEnumNoIndent(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        return innerEnumRenderer.render(innerEnum, compilationUnit);
    }

    private static Stream<String> renderInnerEnum(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(innerEnumRenderer.render(innerEnum, compilationUnit).stream());
    }

    public static List<String> renderImports(CompilationUnit compilationUnit) {
        Set importedTypes = compilationUnit.getImportedTypes();
        TreeSet imports = new TreeSet();
        HashMap typescriptImportMap = new HashMap();
        HashMap typescriptTypeImportMap = new HashMap();
        importedTypes.stream().filter(javaType -> !StringUtils.startsWith((CharSequence)javaType.getPackageName(), (CharSequence)"java")).filter(fullyQualifiedJavaType -> fullyQualifiedJavaType instanceof FullyQualifiedTypescriptType).map(fullyQualifiedJavaType -> (FullyQualifiedTypescriptType)((Object)fullyQualifiedJavaType)).forEach(fullyQualifiedTypescriptType -> {
            Object key = fullyQualifiedTypescriptType.getPackagePath();
            if (fullyQualifiedTypescriptType.isInterface()) {
                key = (String)key + "-true";
                TypescriptImport typescriptImport = typescriptTypeImportMap.computeIfAbsent(key, k -> new TypescriptImport(fullyQualifiedTypescriptType.getPackagePath(), true));
                typescriptImport.getObjects().add(fullyQualifiedTypescriptType.getShortName());
            } else {
                key = (String)key + "-false";
                TypescriptImport typescriptImport = typescriptImportMap.computeIfAbsent(key, k -> new TypescriptImport(fullyQualifiedTypescriptType.getPackagePath(), false));
                typescriptImport.getObjects().add(fullyQualifiedTypescriptType.getShortName());
            }
        });
        importedTypes.stream().filter(javaType -> !StringUtils.startsWith((CharSequence)javaType.getPackageName(), (CharSequence)"java")).filter(fullyQualifiedJavaType -> !(fullyQualifiedJavaType instanceof FullyQualifiedTypescriptType)).forEach(fullyQualifiedJavaType -> {
            String packageName = fullyQualifiedJavaType.getPackageName();
            TypescriptImport typescriptImport = typescriptImportMap.computeIfAbsent(packageName, key -> new TypescriptImport(fullyQualifiedJavaType.getPackageName(), false));
            typescriptImport.getObjects().add(fullyQualifiedJavaType.getShortName());
        });
        ArrayList importList = new ArrayList(typescriptImportMap.values());
        importList.addAll(typescriptTypeImportMap.values());
        importList.forEach(javaType -> imports.add(RenderingUtilities.renderTypeImport(javaType)));
        if (imports.isEmpty()) {
            return Collections.emptyList();
        }
        return RenderingUtilities.addEmptyLine(imports.stream().sorted(Comparator.reverseOrder())).collect(Collectors.toList());
    }

    private static String renderTypeImport(TypescriptImport typescriptImport) {
        if (typescriptImport.isInterface()) {
            return "import type { " + StringUtils.join((Iterable)typescriptImport.getObjects().stream().sorted().collect(Collectors.toList()), (String)", ") + " } from '" + typescriptImport.getPath() + "';";
        }
        return "import { " + StringUtils.join((Iterable)typescriptImport.getObjects().stream().sorted().collect(Collectors.toList()), (String)", ") + " } from '" + typescriptImport.getPath() + "';";
    }

    private static String renderImport(FullyQualifiedJavaType javaType) {
        String importName = javaType.getShortName();
        String fileName = javaType.getPackageName();
        String packageName = fileName.replaceAll("\\.", "/");
        return "import { " + importName + " } from '" + packageName + "';";
    }

    private static Set<String> renderImports(Set<FullyQualifiedJavaType> imports) {
        return imports.stream().filter(javaType -> !StringUtils.startsWith((CharSequence)javaType.getPackageName(), (CharSequence)"java")).map(javaType -> {
            String importName = javaType.getShortName();
            String fileName = javaType.getPackageName();
            String packageName = fileName.replaceAll("\\.", "/");
            return "import { " + importName + " } from '" + packageName + "';";
        }).collect(Collectors.toCollection(TreeSet::new));
    }

    public static String javaIndent(String in) {
        if (in.isEmpty()) {
            return in;
        }
        return JAVA_INDENT + in;
    }

    public static List<String> removeLastEmptyLine(List<String> lines) {
        if (lines.isEmpty()) {
            return lines;
        }
        if (lines.get(lines.size() - 1).isEmpty()) {
            return lines.subList(0, lines.size() - 1);
        }
        return lines;
    }

    public static String calculateTypescriptTypeName(CompilationUnit compilationUnit, FullyQualifiedJavaType fqjt) {
        if (fqjt.isArray()) {
            String fqn = fqjt.getFullyQualifiedName();
            String typeName = RenderingUtilities.calculateTypescriptTypeName(compilationUnit, new FullyQualifiedJavaType(fqn.substring(0, fqn.indexOf(91))));
            return typeName + fqn.substring(fqn.indexOf(91));
        }
        if (!fqjt.getTypeArguments().isEmpty()) {
            return RenderingUtilities.calculateParameterizedTypeName(compilationUnit, fqjt);
        }
        if (compilationUnit == null || RenderingUtilities.typeDoesNotRequireImport(fqjt) || RenderingUtilities.typeIsInSamePackage(compilationUnit, fqjt) || RenderingUtilities.typeIsAlreadyImported(compilationUnit, fqjt)) {
            return RenderingUtilities.javaToTypescriptType(fqjt);
        }
        return fqjt.getFullyQualifiedName();
    }

    public static String javaToTypescriptType(FullyQualifiedJavaType javaType) {
        String type = javaType.getFullyQualifiedNameWithoutTypeParameters();
        if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"java.lang.Long", "java.lang.Short", "java.lang.Integer", "Long", "Short", "Integer"})) {
            return "number";
        }
        if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"java.lang.String", "String"})) {
            return "string";
        }
        if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"java.lang.Boolean", "Boolean"})) {
            return "boolean";
        }
        if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"java.lang.Object", "Object"})) {
            return "any";
        }
        if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"java.time.LocalDate", "java.time.LocalDateTime", "LocalDate", "LocalDateTime"})) {
            return "string";
        }
        if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"java.util.Map", "Map"})) {
            if (javaType.getTypeArguments().size() > 0) {
                return "Map";
            }
            return "any";
        }
        return javaType.getShortName();
    }

    private static String calculateParameterizedTypeName(CompilationUnit compilationUnit, FullyQualifiedJavaType fqjt) {
        String baseTypeName = RenderingUtilities.javaToTypescriptType(fqjt);
        if (StringUtils.equalsAny((CharSequence)fqjt.getFullyQualifiedNameWithoutTypeParameters(), (CharSequence[])new CharSequence[]{"java.util.List", "java.util.Collection", "java.util.Set"}) && fqjt.getTypeArguments().size() == 1) {
            return RenderingUtilities.javaToTypescriptType((FullyQualifiedJavaType)fqjt.getTypeArguments().get(0)) + "[]";
        }
        return fqjt.getTypeArguments().stream().map(t -> RenderingUtilities.calculateTypescriptTypeName(compilationUnit, t)).collect(Collectors.joining(", ", baseTypeName + "<", ">"));
    }

    private static boolean typeDoesNotRequireImport(FullyQualifiedJavaType fullyQualifiedJavaType) {
        return fullyQualifiedJavaType.isPrimitive() || !fullyQualifiedJavaType.isExplicitlyImported();
    }

    private static boolean typeIsInSamePackage(CompilationUnit compilationUnit, FullyQualifiedJavaType fullyQualifiedJavaType) {
        return fullyQualifiedJavaType.getPackageName().equals(compilationUnit.getType().getPackageName());
    }

    private static boolean typeIsAlreadyImported(CompilationUnit compilationUnit, FullyQualifiedJavaType fullyQualifiedJavaType) {
        String name = fullyQualifiedJavaType.getFullyQualifiedNameWithoutTypeParameters();
        return compilationUnit.getImportedTypes().stream().anyMatch(e -> e.getImportList().contains(name));
    }
}

