/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript.render;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.entframework.kernel.db.generator.typescript.render.BodyLineRenderer;
import net.entframework.kernel.db.generator.typescript.render.ParameterRenderer;
import net.entframework.kernel.db.generator.typescript.render.TypeParameterRenderer;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TypeParameter;
import org.mybatis.generator.internal.util.CustomCollectors;

public class MethodRenderer {
    private final TypeParameterRenderer typeParameterRenderer = new TypeParameterRenderer();
    private final ParameterRenderer parameterRenderer = new ParameterRenderer();
    private final BodyLineRenderer bodyLineRenderer = new BodyLineRenderer();

    public List<String> render(Method method, boolean inInterface, CompilationUnit compilationUnit) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(method.getJavaDocLines());
        lines.addAll(method.getAnnotations());
        lines.add(this.getFirstLine(method, inInterface, compilationUnit));
        if (!method.isAbstract() && !method.isNative()) {
            lines.addAll(this.bodyLineRenderer.render(method.getBodyLines()));
        }
        if (method.getBodyLines().size() > 1) {
            lines.add("}");
        }
        return lines;
    }

    private String getFirstLine(Method method, boolean inInterface, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.renderVisibility(method, inInterface));
        sb.append("const ");
        sb.append(method.getName());
        sb.append(" = ");
        sb.append(this.renderParameters(method, compilationUnit));
        sb.append(" =>");
        if (method.getBodyLines().size() > 1) {
            sb.append(" {");
        }
        return sb.toString();
    }

    private String renderVisibility(Method method, boolean inInterface) {
        if (inInterface && method.getVisibility() == JavaVisibility.PUBLIC) {
            return "";
        }
        if (method.getVisibility() == JavaVisibility.PUBLIC) {
            return "export ";
        }
        return "";
    }

    private String renderTypeParameters(Method method, CompilationUnit compilationUnit) {
        return (String)method.getTypeParameters().stream().map(tp -> this.typeParameterRenderer.render((TypeParameter)tp, compilationUnit)).collect(CustomCollectors.joining((CharSequence)", ", (CharSequence)"<", (CharSequence)"> "));
    }

    private String renderParameters(Method method, CompilationUnit compilationUnit) {
        return method.getParameters().stream().map(p -> this.parameterRenderer.render((Parameter)p, compilationUnit)).collect(Collectors.joining(", ", "(", ")"));
    }

    private String renderExceptions(Method method, CompilationUnit compilationUnit) {
        return (String)method.getExceptions().stream().map(jt -> JavaDomUtils.calculateTypeName((CompilationUnit)compilationUnit, (FullyQualifiedJavaType)jt)).collect(CustomCollectors.joining((CharSequence)", ", (CharSequence)" throws ", (CharSequence)""));
    }
}

