/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript.render;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.entframework.kernel.db.generator.typescript.render.RenderingUtilities;
import net.entframework.kernel.db.generator.utils.EnumInfo;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.internal.util.CustomCollectors;

public class InnerEnumRenderer {
    public List<String> render(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        List<String> lines = new ArrayList<String>();
        lines.addAll(innerEnum.getJavaDocLines());
        lines.add(this.renderFirstLine(innerEnum, compilationUnit));
        lines.addAll(this.renderEnums(innerEnum));
        lines.add("}");
        lines.add(this.renderFirstTypeLine(innerEnum, compilationUnit));
        lines.addAll(RenderingUtilities.renderFields(innerEnum.getFields(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInnerClasses(innerEnum.getInnerClasses(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInnerInterfaces(innerEnum.getInnerInterfaces(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInnerEnums(innerEnum.getInnerEnums(), compilationUnit));
        lines = RenderingUtilities.removeLastEmptyLine(lines);
        lines.add("}");
        lines.addAll(this.renderEnumVariables(innerEnum));
        lines.addAll(this.renderEnumArray(innerEnum));
        return lines;
    }

    public List<String> renderEnums(InnerEnum innerEnum) {
        ArrayList<CallSite> answer = new ArrayList<CallSite>();
        EnumInfo enumInfo = (EnumInfo)innerEnum.getAttribute("TABLE_ENUM_FIELD_ATTR_SOURCE");
        if (enumInfo != null && !enumInfo.getItems().isEmpty()) {
            for (EnumInfo.EnumItemInfo item : enumInfo.getItems()) {
                Object value = item.getOriginalValue();
                String valueExp = String.valueOf(value);
                if (value instanceof String) {
                    valueExp = StringUtils.wrap((String)valueExp, (String)"'");
                }
                answer.add((CallSite)((Object)(item.getConstant() + " = " + valueExp + ",")));
            }
        }
        return answer.stream().map(RenderingUtilities::javaIndent).toList();
    }

    private String renderFirstTypeLine(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append("export interface ");
        sb.append(innerEnum.getType().getShortName() + "Type");
        sb.append(this.renderSuperInterfaces(innerEnum, compilationUnit));
        sb.append(" {");
        return sb.toString();
    }

    private String renderFirstLine(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append("export enum ");
        sb.append(innerEnum.getType().getShortName());
        sb.append(" {");
        return sb.toString();
    }

    private List<String> renderEnumConstants(InnerEnum innerEnum) {
        ArrayList<String> answer = new ArrayList<String>();
        Iterator iter = innerEnum.getEnumConstants().iterator();
        while (iter.hasNext()) {
            String enumConstant = (String)iter.next();
            if (iter.hasNext()) {
                answer.add("  " + enumConstant + ",");
                continue;
            }
            answer.add("  " + enumConstant + ",");
        }
        answer.add("");
        return answer;
    }

    private List<String> renderEnumArray(InnerEnum innerEnum) {
        ArrayList<String> answer = new ArrayList<String>();
        EnumInfo enumInfo = (EnumInfo)innerEnum.getAttribute("TABLE_ENUM_FIELD_ATTR_SOURCE");
        if (enumInfo != null && !enumInfo.getItems().isEmpty()) {
            List<String> names = enumInfo.getItems().stream().map(EnumInfo.EnumItemInfo::getConstant).toList();
            answer.add("export const " + innerEnum.getType().getShortName() + "Types = [" + StringUtils.join(names, (String)", ") + "];");
        }
        return answer;
    }

    private List<String> renderEnum(InnerEnum innerEnum) {
        ArrayList<String> answer = new ArrayList<String>();
        EnumInfo enumInfo = (EnumInfo)innerEnum.getAttribute("TABLE_ENUM_FIELD_ATTR_SOURCE");
        if (enumInfo != null && !enumInfo.getItems().isEmpty()) {
            List<String> names = enumInfo.getItems().stream().map(EnumInfo.EnumItemInfo::getConstant).toList();
            answer.add("export const " + innerEnum.getType().getShortName() + "Types = [" + StringUtils.join(names, (String)", ") + "];");
        }
        return answer;
    }

    private List<String> renderEnumVariables(InnerEnum innerEnum) {
        ArrayList<String> answer = new ArrayList<String>();
        EnumInfo enumInfo = (EnumInfo)innerEnum.getAttribute("TABLE_ENUM_FIELD_ATTR_SOURCE");
        if (enumInfo != null && !enumInfo.getItems().isEmpty()) {
            for (EnumInfo.EnumItemInfo item : enumInfo.getItems()) {
                Object value = item.getOriginalValue();
                String valueExp = String.valueOf(value);
                if (value instanceof String) {
                    valueExp = StringUtils.wrap((String)valueExp, (String)"'");
                }
                answer.add("export const " + item.getConstant() + ": " + innerEnum.getType().getShortName() + "Type = { value: " + valueExp + ", label: '" + item.getLabel() + "' };");
                answer.add("");
            }
        }
        return answer;
    }

    private String renderSuperInterfaces(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        return (String)innerEnum.getSuperInterfaceTypes().stream().map(tp -> JavaDomUtils.calculateTypeName((CompilationUnit)compilationUnit, (FullyQualifiedJavaType)tp)).collect(CustomCollectors.joining((CharSequence)", ", (CharSequence)" implements ", (CharSequence)""));
    }
}

