/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript.render;

import java.util.ArrayList;
import java.util.List;
import net.entframework.kernel.db.generator.typescript.render.RenderingUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.internal.util.CustomCollectors;

public class InnerClassRenderer {
    public List<String> render(InnerClass innerClass, CompilationUnit compilationUnit) {
        List<String> lines = new ArrayList<String>();
        lines.addAll(innerClass.getJavaDocLines());
        if (innerClass.getFields().size() > 0) {
            lines.add(this.renderFirstLine(innerClass, compilationUnit));
            lines.addAll(RenderingUtilities.renderFields(innerClass.getFields(), compilationUnit));
            lines.addAll(RenderingUtilities.renderInnerInterfaces(innerClass.getInnerInterfaces(), compilationUnit));
            lines = RenderingUtilities.removeLastEmptyLine(lines);
            lines.add("}");
        }
        if (innerClass.getMethods().size() > 0) {
            lines.addAll(RenderingUtilities.renderClassOrEnumMethods(innerClass.getMethods(), compilationUnit));
            lines = RenderingUtilities.removeLastEmptyLine(lines);
        }
        lines.addAll(RenderingUtilities.renderInnerClasses(innerClass.getInnerClasses(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInitializationBlocks(innerClass.getInitializationBlocks()));
        lines.addAll(RenderingUtilities.renderInnerEnums(innerClass.getInnerEnums(), compilationUnit));
        return lines;
    }

    private String renderFirstLine(InnerClass innerClass, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append("export interface ");
        sb.append(innerClass.getType().getShortName());
        sb.append(RenderingUtilities.renderTypeParameters(innerClass.getTypeParameters(), compilationUnit));
        sb.append(this.renderSuperClass(innerClass, compilationUnit));
        sb.append(this.renderSuperInterfaces(innerClass, compilationUnit));
        sb.append(" {");
        return sb.toString();
    }

    private String renderSuperClass(InnerClass innerClass, CompilationUnit compilationUnit) {
        return innerClass.getSuperClass().map(sc -> " extends " + JavaDomUtils.calculateTypeName((CompilationUnit)compilationUnit, (FullyQualifiedJavaType)sc)).orElse("");
    }

    private String renderSuperInterfaces(InnerClass innerClass, CompilationUnit compilationUnit) {
        return (String)innerClass.getSuperInterfaceTypes().stream().map(tp -> JavaDomUtils.calculateTypeName((CompilationUnit)compilationUnit, (FullyQualifiedJavaType)tp)).collect(CustomCollectors.joining((CharSequence)", ", (CharSequence)" implements ", (CharSequence)""));
    }
}

