/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.typescript.runtime.FullyQualifiedTypescriptType;
import net.entframework.kernel.db.generator.typescript.runtime.TypescriptTopLevelClass;
import net.entframework.kernel.db.generator.utils.ClassInfo;
import net.entframework.kernel.db.generator.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.JavaTypeResolver;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InitializationBlock;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.java.TopLevelEnumeration;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.messages.Messages;

public class TypescriptModelGenerator
extends AbstractJavaGenerator {
    public TypescriptModelGenerator(String project) {
        super(project);
    }

    private void prepare() {
    }

    public List<CompilationUnit> getCompilationUnits() {
        String projectRootAlias = this.context.getProperty("projectRootAlias");
        if (StringUtils.isBlank((CharSequence)projectRootAlias)) {
            projectRootAlias = "";
        }
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString((String)"Progress.8", (Object[])new Object[]{table.toString()}));
        Plugin plugins = this.context.getPlugins();
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        String camelCaseName = JavaBeansUtil.convertCamelCase((String)table.getDomainObjectName(), (String)"-");
        String typescriptModelPackage = this.context.getJavaModelGeneratorConfiguration().getTargetPackage();
        FullyQualifiedTypescriptType tsBaseModelJavaType = new FullyQualifiedTypescriptType(projectRootAlias, typescriptModelPackage + "." + camelCaseName + "." + table.getDomainObjectName(), true);
        TypescriptTopLevelClass topLevelClass = new TypescriptTopLevelClass(tsBaseModelJavaType);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.setDescription(this.introspectedTable.getRemarks());
        commentGenerator.addJavaFileComment((CompilationUnit)topLevelClass);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        commentGenerator.addModelClassComment((TopLevelClass)topLevelClass, this.introspectedTable);
        List introspectedColumns = this.introspectedTable.getAllColumns();
        JavaTypeResolver typeResolver = ObjectFactory.createJavaTypeResolver((Context)this.context, Collections.emptyList());
        for (IntrospectedColumn introspectedColumn : introspectedColumns) {
            Field field = WebUtils.getTypescriptField(introspectedColumn, this.context, this.introspectedTable, (CompilationUnit)topLevelClass);
            field.setDescription(introspectedColumn.getRemarks());
            GeneratorUtils.addComment((JavaElement)field, introspectedColumn.getRemarks());
            FullyQualifiedJavaType actualType = typeResolver.calculateJavaType(null, introspectedColumn);
            if (!actualType.equals((Object)introspectedColumn.getFullyQualifiedJavaType())) {
                ClassInfo classInfo = ClassInfo.getInstance(introspectedColumn.getFullyQualifiedJavaType().getFullyQualifiedName());
                if (classInfo != null && classInfo.isEnum()) {
                    String enumPackage = typescriptModelPackage + ".enum";
                    TopLevelEnumeration topLevelEnumeration = classInfo.toTopLevelEnumeration(enumPackage, introspectedColumn.getFullyQualifiedJavaType().getShortName(), projectRootAlias);
                    topLevelEnumeration.setWriteMode(WriteMode.OVER_WRITE);
                    FullyQualifiedJavaType fqjt = topLevelEnumeration.getType();
                    field.setType(fqjt);
                    answer.add((CompilationUnit)topLevelEnumeration);
                } else {
                    field.setType(actualType);
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)introspectedColumn.getActualColumnName(), (CharSequence)this.introspectedTable.getTableConfiguration().getLogicDeleteColumn())) {
                field.setAttribute("FIELD_LOGIC_DELETE_ATTR", (Object)true);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)introspectedColumn.getActualColumnName(), (CharSequence)this.introspectedTable.getTableConfiguration().getVersionColumn())) {
                field.setAttribute("FIELD_VERSION_ATTR", (Object)true);
            }
            if (!plugins.modelFieldGenerated(field, (TopLevelClass)topLevelClass, introspectedColumn, this.introspectedTable, Plugin.ModelClassType.BASE_RECORD)) continue;
            topLevelClass.addField(field);
            topLevelClass.addImportedType(field.getType());
        }
        if (this.context.getPlugins().modelBaseRecordClassGenerated((TopLevelClass)topLevelClass, this.introspectedTable)) {
            InitializationBlock initializationBlock = new InitializationBlock();
            initializationBlock.addBodyLine(String.format("export type %sPageModel = BasicFetchResult<%s>;", table.getDomainObjectName(), table.getDomainObjectName()));
            topLevelClass.addImportedType(new FullyQualifiedTypescriptType("", "fe-ent-core.es.logics.types.BasicFetchResult", true));
            topLevelClass.addInitializationBlock(initializationBlock);
            this.introspectedTable.setAttribute("INTROSPECTED_TABLE_MODEL_CLASS", (Object)topLevelClass);
            answer.add((CompilationUnit)topLevelClass);
        }
        return answer;
    }
}

