/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.entframework.kernel.db.generator.typescript.TypescriptClientGenerator;
import net.entframework.kernel.db.generator.typescript.TypescriptModelGenerator;
import net.entframework.kernel.db.generator.typescript.runtime.GeneratedTypescriptFile;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedKotlinFile;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.codegen.AbstractGenerator;
import org.mybatis.generator.codegen.AbstractJavaGenerator;

public class IntrospectedTableTypescriptImpl
extends IntrospectedTable {
    protected final List<AbstractJavaGenerator> javaGenerators = new ArrayList<AbstractJavaGenerator>();

    public IntrospectedTableTypescriptImpl() {
        super(IntrospectedTable.TargetRuntime.MYBATIS3_DSQL);
    }

    public void calculateGenerators(List<String> warnings, ProgressCallback progressCallback) {
        TypescriptModelGenerator javaGenerator = new TypescriptModelGenerator(this.getModelProject());
        this.initializeAbstractGenerator((AbstractGenerator)javaGenerator, warnings, progressCallback);
        if (this.context.getJavaClientGeneratorConfiguration() != null) {
            TypescriptClientGenerator typescriptApiGenerator = new TypescriptClientGenerator(this.getModelProject());
            this.initializeAbstractGenerator((AbstractGenerator)typescriptApiGenerator, warnings, progressCallback);
            this.javaGenerators.add((AbstractJavaGenerator)typescriptApiGenerator);
        }
        this.javaGenerators.add(javaGenerator);
    }

    private String getModelProject() {
        return this.context.getJavaModelGeneratorConfiguration().getTargetProject();
    }

    protected void initializeAbstractGenerator(AbstractGenerator abstractGenerator, List<String> warnings, ProgressCallback progressCallback) {
        if (abstractGenerator == null) {
            return;
        }
        abstractGenerator.setContext(this.context);
        abstractGenerator.setIntrospectedTable((IntrospectedTable)this);
        abstractGenerator.setProgressCallback(progressCallback);
        abstractGenerator.setWarnings(warnings);
    }

    public List<GeneratedJavaFile> getGeneratedJavaFiles() {
        ArrayList<GeneratedJavaFile> answer = new ArrayList<GeneratedJavaFile>();
        for (AbstractJavaGenerator javaGenerator : this.javaGenerators) {
            List compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                GeneratedTypescriptFile gjf = new GeneratedTypescriptFile(compilationUnit, javaGenerator.getProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        return answer;
    }

    public List<GeneratedXmlFile> getGeneratedXmlFiles() {
        return Collections.emptyList();
    }

    public List<GeneratedKotlinFile> getGeneratedKotlinFiles() {
        return Collections.emptyList();
    }

    public int getGenerationSteps() {
        return 0;
    }

    public boolean requiresXMLGenerator() {
        return false;
    }
}

