/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.web.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import net.entframework.kernel.db.generator.plugin.web.freemarker.ProxyTemplateLoader;
import org.apache.commons.lang3.StringUtils;

public class FreemarkerTemplateEngine {
    private static Configuration configuration;

    public static synchronized void init(String baseDir) throws IOException {
        if (configuration == null) {
            configuration = new Configuration(Configuration.VERSION_2_3_31);
            configuration.setDefaultEncoding("UTF-8");
            if (StringUtils.isNotEmpty((CharSequence)baseDir)) {
                ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(FreemarkerTemplateEngine.class, "/");
                FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(new File(baseDir));
                ProxyTemplateLoader multiTemplateLoader = new ProxyTemplateLoader(new TemplateLoader[]{classTemplateLoader, fileTemplateLoader});
                configuration.setTemplateLoader((TemplateLoader)multiTemplateLoader);
            } else {
                ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(FreemarkerTemplateEngine.class, "/");
                configuration.setTemplateLoader((TemplateLoader)classTemplateLoader);
            }
            configuration.setClassicCompatible(true);
            configuration.getCacheStorage().clear();
        }
    }

    public static String process(Map<String, Object> objectMap, String templatePath) throws Exception {
        Template template = configuration.getTemplate(templatePath);
        BeansWrapper wrapper = new BeansWrapper(new Version(2, 3, 31));
        TemplateHashModel statics = wrapper.getStaticModels();
        objectMap.put("statics", statics);
        String output = null;
        try (StringWriter stringWriter = new StringWriter();){
            template.process(objectMap, (Writer)stringWriter);
            output = stringWriter.getBuffer().toString();
        }
        return output;
    }
}

