/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.web;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.entframework.kernel.db.generator.plugin.web.AbstractWebPlugin;
import net.entframework.kernel.db.generator.plugin.web.freemarker.FreemarkerTemplateEngine;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTemplatePlugin
extends AbstractWebPlugin {
    private static final String VAR_START = "var_";
    protected String templatePath;
    protected String fileName;
    protected String fileExt;
    protected String modelPath;
    protected String targetPackage;
    protected boolean enableSubPackages = true;

    @Override
    public boolean validate(List<String> warnings) {
        String enableSubPackages;
        File file;
        boolean validate = super.validate(warnings);
        ArrayList<Object> errors = new ArrayList<Object>();
        String templateBaseDir = this.context.getProperty("templateBaseDir");
        if (StringUtils.isNotEmpty((CharSequence)templateBaseDir) && !(file = new File(templateBaseDir)).isDirectory()) {
            errors.add(String.format("\u5168\u5c40\u53d8\u91cftemplateBaseDir: %s\u4e0d\u53ef\u8bbf\u95ee", templateBaseDir));
        }
        try {
            FreemarkerTemplateEngine.init(templateBaseDir);
        }
        catch (IOException e) {
            errors.add("Freemarker\u521d\u59cb\u5316\u5931\u8d25");
            this.log.error(e.getMessage());
        }
        this.targetPackage = this.properties.getProperty("targetPackage");
        this.fileName = this.properties.getProperty("fileName");
        this.fileExt = this.properties.getProperty("fileExt");
        this.templatePath = this.properties.getProperty("templatePath");
        if (StringUtils.isNotEmpty((CharSequence)this.typescriptModelPackage)) {
            this.modelPath = StringUtils.replace((String)this.typescriptModelPackage, (String)".", (String)"/");
        }
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.targetPackage, this.templatePath, this.fileName, this.fileExt})) {
            errors.add("\u8bf7\u68c0\u67e5" + ((Object)((Object)this)).getClass().getName() + ", targetPackage | templatePath | fileName | fileExt \u914d\u7f6e");
        }
        if (StringUtils.isNotEmpty((CharSequence)(enableSubPackages = this.properties.getProperty("enableSubPackages"))) && "false".equalsIgnoreCase(enableSubPackages)) {
            this.enableSubPackages = false;
        }
        if (!errors.isEmpty()) {
            warnings.addAll(errors);
            return false;
        }
        return validate;
    }

    protected Map<String, String> getAdditionalPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<Object> enu = this.properties.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)VAR_START)) continue;
            map.put(StringUtils.substringAfter((String)key, (String)VAR_START), this.properties.getProperty(key));
        }
        return map;
    }
}

