/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server.methods;

import java.util.Optional;
import net.entframework.kernel.db.generator.plugin.server.methods.MethodAndImports;
import net.entframework.kernel.db.generator.plugin.server.methods.MethodParts;
import net.entframework.kernel.db.generator.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.AbstractJavaType;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;

public abstract class AbstractMethodGenerator {
    protected final Context context;
    protected final IntrospectedTable introspectedTable;
    protected final AbstractJavaType hostJavaClass;
    protected final Interface clientInterface;
    protected final String tableFieldName;
    protected final FullyQualifiedJavaType recordType;
    protected final boolean isAbstract;
    protected final String pojoRequestTargetPackage;
    protected final String pojoRequestSuffix;
    protected final String pojoResponseTargetPackage;
    protected final String pojoResponseSuffix;
    protected final String repositoryTargetPackage;
    protected final String repositorySuffix;
    protected final String mapstructTargetPackage;
    protected final String mapstructSuffix;

    protected AbstractMethodGenerator(BuildConfig config) {
        this.context = config.context;
        this.introspectedTable = config.introspectedTable;
        this.hostJavaClass = config.hostJavaClass;
        this.clientInterface = config.clientInterface;
        this.tableFieldName = config.tableFieldName;
        this.recordType = config.recordType;
        this.isAbstract = config.isAbstract;
        this.pojoRequestTargetPackage = this.context.getProperty("pojoRequestTargetPackage");
        this.pojoRequestSuffix = PropertyUtils.getProperty(this.context, "pojoRequestSuffix", "Request");
        this.pojoResponseTargetPackage = this.context.getProperty("pojoResponseTargetPackage");
        this.pojoResponseSuffix = PropertyUtils.getProperty(this.context, "pojoResponseSuffix", "Response");
        this.repositoryTargetPackage = this.context.getProperty("repositoryTargetPackage");
        this.repositorySuffix = PropertyUtils.getProperty(this.context, "repositorySuffix", "Repository");
        this.mapstructTargetPackage = this.context.getProperty("mapstructTargetPackage");
        this.mapstructSuffix = PropertyUtils.getProperty(this.context, "mapstructSuffix", "Converter");
    }

    protected String calculateFieldName(IntrospectedColumn column) {
        return AbstractMethodGenerator.calculateFieldName(this.tableFieldName, column);
    }

    public static String calculateFieldName(String tableFieldName, IntrospectedColumn column) {
        Object fieldName = column.getJavaProperty();
        if (((String)fieldName).equals(tableFieldName)) {
            fieldName = tableFieldName + "." + (String)fieldName;
        }
        return fieldName;
    }

    protected void acceptParts(MethodAndImports.Builder builder, Method method, MethodParts methodParts) {
        for (Parameter parameter : methodParts.getParameters()) {
            method.addParameter(parameter);
        }
        for (String annotation : methodParts.getAnnotations()) {
            method.addAnnotation(annotation);
        }
        method.addBodyLines(methodParts.getBodyLines());
        builder.withImports(methodParts.getImports());
    }

    public FullyQualifiedJavaType getPojoRequestJavaType() {
        return new FullyQualifiedJavaType(this.pojoRequestTargetPackage + "." + this.recordType.getShortName() + this.pojoRequestSuffix);
    }

    public FullyQualifiedJavaType getMapperSupportJavaType() {
        return new FullyQualifiedJavaType(this.context.getJavaModelGeneratorConfiguration().getTargetPackage() + "." + this.recordType.getShortName() + "_");
    }

    public FullyQualifiedJavaType getMapperSupportJavaType(String shortName) {
        return new FullyQualifiedJavaType(this.context.getJavaModelGeneratorConfiguration().getTargetPackage() + "." + shortName + "_");
    }

    public FullyQualifiedJavaType getPojoResponseJavaType() {
        return new FullyQualifiedJavaType(this.pojoResponseTargetPackage + "." + this.recordType.getShortName() + this.pojoResponseSuffix);
    }

    public FullyQualifiedJavaType getMapperJavaType() {
        return new FullyQualifiedJavaType(this.context.getJavaClientGeneratorConfiguration().getTargetPackage() + "." + this.recordType.getShortName() + "Mapper");
    }

    public FullyQualifiedJavaType getMapperJavaType(String shortName) {
        return new FullyQualifiedJavaType(this.context.getJavaClientGeneratorConfiguration().getTargetPackage() + "." + shortName + "Mapper");
    }

    public FullyQualifiedJavaType getRepositoryJavaType() {
        return new FullyQualifiedJavaType(this.repositoryTargetPackage + "." + this.recordType.getShortName() + this.repositorySuffix);
    }

    public FullyQualifiedJavaType getRepositoryJavaType(String shortName) {
        return new FullyQualifiedJavaType(this.repositoryTargetPackage + "." + shortName + this.repositorySuffix);
    }

    public FullyQualifiedJavaType getMapstructJavaType() {
        return new FullyQualifiedJavaType(this.mapstructTargetPackage + "." + this.recordType.getShortName() + this.mapstructSuffix);
    }

    public Field findMapperField(TopLevelClass topLevelClass, String fieldName, FullyQualifiedJavaType javaType) {
        Optional<Field> foundField = topLevelClass.getFields().stream().filter(field -> StringUtils.equals((CharSequence)fieldName, (CharSequence)field.getName())).findFirst();
        if (foundField.isPresent()) {
            return foundField.get();
        }
        Field created = new Field(fieldName, javaType);
        created.setVisibility(JavaVisibility.PROTECTED);
        created.addAnnotation("@Resource");
        topLevelClass.addImportedType("jakarta.annotation.Resource");
        topLevelClass.addField(created);
        topLevelClass.addImportedType(javaType);
        return created;
    }

    public abstract MethodAndImports generateMethodAndImports();

    public static class BuildConfig {
        private Context context;
        private IntrospectedTable introspectedTable;
        private AbstractJavaType hostJavaClass;
        private Interface clientInterface;
        private String tableFieldName;
        private FullyQualifiedJavaType recordType;
        private boolean isAbstract;

        public BuildConfig withContext(Context context) {
            this.context = context;
            return this.getThis();
        }

        public BuildConfig withIntrospectedTable(IntrospectedTable introspectedTable) {
            this.introspectedTable = introspectedTable;
            return this.getThis();
        }

        public BuildConfig withHostJavaClass(AbstractJavaType javaType) {
            this.hostJavaClass = javaType;
            return this.getThis();
        }

        public BuildConfig withClientInterface(Interface clientInterface) {
            this.clientInterface = clientInterface;
            return this.getThis();
        }

        public BuildConfig withRecordType(FullyQualifiedJavaType recordType) {
            this.recordType = recordType;
            return this.getThis();
        }

        public BuildConfig withTableFieldName(String tableFieldName) {
            this.tableFieldName = tableFieldName;
            return this.getThis();
        }

        public BuildConfig withAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this.getThis();
        }

        public BuildConfig getThis() {
            return this;
        }
    }
}

