/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.JoinTarget;

public class Utils {
    public static Set<FullyQualifiedJavaType> getRelatedFieldType(IntrospectedTable introspectedTable) {
        List<Field> fields;
        HashSet<FullyQualifiedJavaType> relatedFieldType = new HashSet<FullyQualifiedJavaType>();
        TopLevelClass modelClass = (TopLevelClass)introspectedTable.getAttribute("INTROSPECTED_TABLE_MODEL_CLASS");
        if (GeneratorUtils.hasRelation(modelClass, JoinTarget.JoinType.MANY_TO_ONE) && (fields = GeneratorUtils.getRelatedFields(modelClass, JoinTarget.JoinType.MANY_TO_ONE)).size() > 0) {
            for (Field field : fields) {
                relatedFieldType.add(field.getType());
            }
        }
        if (GeneratorUtils.hasRelation(modelClass, JoinTarget.JoinType.ONE_TO_MANY) && (fields = GeneratorUtils.getRelatedFields(modelClass, JoinTarget.JoinType.ONE_TO_MANY)).size() > 0) {
            for (Field field : fields) {
                relatedFieldType.add((FullyQualifiedJavaType)field.getType().getTypeArguments().get(0));
            }
        }
        return relatedFieldType;
    }

    public static String lowerCaseFirstChar(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }
}

