/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.List;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.server.AbstractServerPlugin;
import net.entframework.kernel.db.generator.plugin.server.LombokAnnotation;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class ServicePlugin
extends AbstractServerPlugin {
    @Override
    public boolean validate(List<String> warnings) {
        boolean validate = super.validate(warnings);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.serviceTargetPackage, this.serviceSuffix})) {
            warnings.add("\u8bf7\u68c0\u67e5ServicePlugin\u914d\u7f6e");
            return false;
        }
        return validate;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        boolean hasGeneratedKeys = introspectedTable.getGeneratedKey().isPresent();
        this.generatedJavaFiles.add(this.generateBaseServiceInterface(interfaze, introspectedTable, hasGeneratedKeys));
        this.generatedJavaFiles.add(this.generateBaseServiceInterfaceImpl(interfaze, introspectedTable, hasGeneratedKeys));
        return true;
    }

    private GeneratedJavaFile generateBaseServiceInterface(Interface clientInterface, IntrospectedTable introspectedTable, boolean hasGeneratedKeys) {
        String baseRecordType = introspectedTable.getBaseRecordType();
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(baseRecordType);
        FullyQualifiedJavaType baseServiceJavaType = this.getServiceJavaType(recordType.getShortName());
        Interface serviceInterface = new Interface(baseServiceJavaType);
        serviceInterface.setVisibility(JavaVisibility.PUBLIC);
        serviceInterface.setWriteMode(this.writeMode == null ? WriteMode.SKIP_ON_EXIST : this.writeMode);
        IntrospectedColumn pkColumn = GeneratorUtils.getPrimaryKey(introspectedTable);
        FullyQualifiedJavaType baseServiceType = new FullyQualifiedJavaType("net.entframework.kernel.db.dao.service.BaseService");
        baseServiceType.addTypeArgument(recordType);
        baseServiceType.addTypeArgument(pkColumn.getFullyQualifiedJavaType());
        serviceInterface.addSuperInterface(baseServiceType);
        serviceInterface.addImportedType(baseServiceType);
        return new GeneratedJavaFile((CompilationUnit)serviceInterface, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
    }

    private GeneratedJavaFile generateBaseServiceInterfaceImpl(Interface clientInterface, IntrospectedTable introspectedTable, boolean hasGeneratedKeys) {
        String baseRecordType = introspectedTable.getBaseRecordType();
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(baseRecordType);
        FullyQualifiedJavaType baseRepositoryJavaType = this.getRepositoryJavaType(recordType.getShortName());
        FullyQualifiedJavaType serviceImplJavaType = this.getServiceImplJavaType(recordType.getShortName());
        TopLevelClass serviceInterfaceImplClass = new TopLevelClass(serviceImplJavaType);
        serviceInterfaceImplClass.setVisibility(JavaVisibility.PUBLIC);
        serviceInterfaceImplClass.setAbstract(false);
        FullyQualifiedJavaType interfaceType = this.getServiceJavaType(recordType.getShortName());
        serviceInterfaceImplClass.setWriteMode(this.writeMode == null ? WriteMode.SKIP_ON_EXIST : this.writeMode);
        serviceInterfaceImplClass.addAnnotation(LombokAnnotation.SLF4J.getName());
        serviceInterfaceImplClass.addImportedType(LombokAnnotation.SLF4J.getJavaType());
        serviceInterfaceImplClass.addSuperInterface(interfaceType);
        serviceInterfaceImplClass.addImportedType(interfaceType);
        IntrospectedColumn pkColumn = GeneratorUtils.getPrimaryKey(introspectedTable);
        FullyQualifiedJavaType baseServiceType = new FullyQualifiedJavaType("net.entframework.kernel.db.dao.service.BaseServiceImpl");
        baseServiceType.addTypeArgument(recordType);
        baseServiceType.addTypeArgument(pkColumn.getFullyQualifiedJavaType());
        serviceInterfaceImplClass.setSuperClass(baseServiceType);
        serviceInterfaceImplClass.addImportedType(baseServiceType);
        Parameter p1 = new Parameter(baseRepositoryJavaType, StringUtils.uncapitalize((String)baseRepositoryJavaType.getShortName()));
        Method defaultConstructor = new Method(serviceImplJavaType.getShortName());
        defaultConstructor.setConstructor(true);
        defaultConstructor.setVisibility(JavaVisibility.PUBLIC);
        defaultConstructor.addParameter(p1);
        defaultConstructor.addBodyLine(String.format("super(%s, %s.class);", p1.getName(), recordType.getShortName()));
        Method method = new Method(serviceImplJavaType.getShortName());
        FullyQualifiedJavaType entityClsJavaType = new FullyQualifiedJavaType(String.format("Class<? extends %s>", recordType.getShortName()));
        method.addParameter(p1);
        serviceInterfaceImplClass.addImportedType(baseRepositoryJavaType);
        Parameter p2 = new Parameter(entityClsJavaType, "entityClass");
        method.addParameter(p2);
        method.setConstructor(true);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addBodyLine(String.format("super(%s, entityClass);", p1.getName()));
        serviceInterfaceImplClass.addMethod(defaultConstructor);
        serviceInterfaceImplClass.addMethod(method);
        return new GeneratedJavaFile((CompilationUnit)serviceInterfaceImplClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        return this.generatedJavaFiles;
    }
}

