/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.List;
import net.entframework.kernel.db.generator.config.Relation;
import net.entframework.kernel.db.generator.plugin.AbstractDynamicSQLPlugin;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JoinEntry;
import org.mybatis.generator.config.JoinTable;
import org.mybatis.generator.config.JoinTarget;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class MyBatisExtPlugin
extends AbstractDynamicSQLPlugin {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        GeneratorUtils.addFieldComment(field, introspectedColumn);
        String fieldDescription = GeneratorUtils.getFieldDescription(introspectedColumn);
        field.setDescription(fieldDescription);
        if (GeneratorUtils.isPrimaryKey(introspectedTable, introspectedColumn)) {
            field.addAnnotation("@Id");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.Id");
        }
        introspectedTable.getGeneratedKey().ifPresent(generatedKey -> {
            if (generatedKey.getColumn().equals(introspectedColumn.getActualColumnName())) {
                field.addAnnotation("@GeneratedValue");
                topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.GeneratedValue");
            }
        });
        if (!GeneratorUtils.isRelationField(field)) {
            StringBuilder sb = new StringBuilder(String.format("@Column(name = \"%s\"", introspectedColumn.getActualColumnName()));
            if (!StringUtils.equals((CharSequence)"OTHER", (CharSequence)introspectedColumn.getJdbcTypeName())) {
                sb.append(", jdbcType = JDBCType.").append(introspectedColumn.getJdbcTypeName());
                topLevelClass.addImportedType(new FullyQualifiedJavaType("java.sql.JDBCType"));
            }
            if (StringUtils.isNotEmpty((CharSequence)introspectedColumn.getTypeHandler())) {
                FullyQualifiedJavaType typeHandler = new FullyQualifiedJavaType(introspectedColumn.getTypeHandler());
                topLevelClass.addImportedType(typeHandler);
                sb.append(", typeHandler = ").append(typeHandler.getShortName()).append(".class");
            }
            sb.append(")");
            field.addAnnotation(sb.toString());
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.Column");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)introspectedColumn.getActualColumnName(), (CharSequence)introspectedTable.getTableConfiguration().getLogicDeleteColumn())) {
            field.addAnnotation("@LogicDelete");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.LogicDelete");
            field.setAttribute("FIELD_LOGIC_DELETE_ATTR", (Object)true);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)introspectedColumn.getActualColumnName(), (CharSequence)introspectedTable.getTableConfiguration().getVersionColumn())) {
            field.addAnnotation("@Version");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.Version");
            field.setAttribute("FIELD_VERSION_ATTR", (Object)true);
        }
        introspectedColumn.getProperties().put("INTROSPECTED_COLUMN_FIELD_BINDING", field);
        if (!GeneratorUtils.isPrimaryKey(introspectedTable, introspectedColumn) && !GeneratorUtils.isRelationField(field)) {
            if (!introspectedColumn.isNullable()) {
                if (GeneratorUtils.isStringField(field)) {
                    field.addAnnotation(String.format("@NotBlank(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\")", fieldDescription));
                    topLevelClass.addImportedType("jakarta.validation.constraints.NotBlank");
                } else {
                    field.addAnnotation(String.format("@NotNull(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\")", fieldDescription));
                    topLevelClass.addImportedType("jakarta.validation.constraints.NotNull");
                }
            }
            if (GeneratorUtils.isStringField(field) && !introspectedColumn.isBLOBColumn()) {
                field.addAnnotation(String.format("@Size(max = %s, message = \"%s\u957f\u5ea6\u8d85\u51fa\")", introspectedColumn.getLength(), fieldDescription));
                topLevelClass.addImportedType("jakarta.validation.constraints.Size");
            }
        }
        if (introspectedColumn.isBlobColumn()) {
            field.addAnnotation("@Blob");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.Blob");
        } else if (introspectedColumn.isClobColumn()) {
            field.addAnnotation("@Clob");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.Clob");
        }
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getFullyQualifiedTable().getIntrospectedTableName();
        JoinEntry joinEntry = this.context.getJoinConfig().getJoinEntry(tableName);
        if (joinEntry != null) {
            this.addJoinField(topLevelClass, joinEntry);
        }
        String fileDescription = GeneratorUtils.getFileDescription(introspectedTable);
        topLevelClass.setDescription(fileDescription);
        introspectedTable.setAttribute("INTROSPECTED_TABLE_MODEL_CLASS", (Object)topLevelClass);
        topLevelClass.addAnnotation("@Entity");
        topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.Entity");
        topLevelClass.addAnnotation(String.format("@Table(value = \"%s\")", introspectedTable.getFullyQualifiedTableNameAtRuntime()));
        topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.Table");
        return true;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getFullyQualifiedTable().getIntrospectedTableName();
        JoinEntry joinEntry = this.context.getJoinConfig().getJoinEntry(tableName);
        if (joinEntry != null) {
            joinEntry.validate();
        }
        String fileDescription = GeneratorUtils.getFileDescription(introspectedTable);
        interfaze.setDescription(fileDescription);
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("net.entframework.kernel.db.mybatis.mapper.BaseMapper");
        fqjt.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        interfaze.addSuperInterface(fqjt);
        interfaze.addImportedType(fqjt);
        return true;
    }

    private void addJoinField(TopLevelClass topLevelClass, JoinEntry joinEntry) {
        IntrospectedTable rightTable;
        for (Pair detail : joinEntry.getDetails()) {
            JoinTarget target = (JoinTarget)detail.getRight();
            rightTable = GeneratorUtils.getIntrospectedTable(this.context, target.getRightTable());
            IntrospectedTable leftTable = GeneratorUtils.getIntrospectedTable(this.context, joinEntry.getLeftTable());
            FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(rightTable.getBaseRecordType());
            FullyQualifiedJavaType listReturnType = FullyQualifiedJavaType.getNewListInstance();
            listReturnType.addTypeArgument(recordType);
            FullyQualifiedJavaType filedType = target.getType() == JoinTarget.JoinType.ONE_TO_MANY ? listReturnType : recordType;
            IntrospectedColumn introspectedColumn = new IntrospectedColumn();
            introspectedColumn.setJavaProperty(target.getFieldName());
            introspectedColumn.setContext(this.context);
            introspectedColumn.setIntrospectedTable(rightTable);
            introspectedColumn.setFullyQualifiedJavaType(filedType);
            introspectedColumn.setActualColumnName(target.getJoinColumn());
            IntrospectedColumn rightTableColumn = GeneratorUtils.getIntrospectedColumnByColumn(rightTable, target.getJoinColumn());
            Field field = JavaBeansUtil.getJavaBeansFieldWithGeneratedAnnotation((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)rightTable, (CompilationUnit)topLevelClass);
            field.setAttribute("FIELD_RELATION", (Object)true);
            if (this.context.getPlugins().modelFieldGenerated(field, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) {
                Relation.Builder builder = Relation.builder();
                topLevelClass.addImportedType(recordType);
                if (target.getType() == JoinTarget.JoinType.ONE_TO_MANY) {
                    topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
                    IntrospectedColumn leftTableColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, (String)detail.getLeft());
                    IntrospectedColumn leftKeyColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, (String)detail.getKey());
                    field.setDescription(GeneratorUtils.getFileDescription(rightTable));
                    builder.joinType(JoinTarget.JoinType.ONE_TO_MANY).bindField(field).sourceField(GeneratorUtils.getFieldByName(topLevelClass, leftKeyColumn.getJavaProperty())).targetTable(rightTable).targetColumn(rightTableColumn);
                    field.addAnnotation("@OneToMany");
                    field.addAnnotation(String.format("@JoinColumn(left = \"%s\", right = \"%s\")", leftTableColumn.getActualColumnName(), rightTableColumn.getActualColumnName()));
                    topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.OneToMany");
                    topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.JoinColumn");
                }
                if (target.getType() == JoinTarget.JoinType.MANY_TO_ONE) {
                    String columnName = (String)detail.getKey();
                    IntrospectedColumn leftColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, columnName);
                    Field relatedField = GeneratorUtils.getFieldByName(topLevelClass, leftColumn.getJavaProperty());
                    field.setDescription(relatedField.getDescription());
                    builder.sourceField(relatedField).joinType(JoinTarget.JoinType.MANY_TO_ONE).bindField(field).targetTable(rightTable).displayField(rightTable.getTableConfiguration().getDisplayField()).targetColumn(GeneratorUtils.getIntrospectedColumnByColumn(rightTable, target.getJoinColumn()));
                    field.addAnnotation("@ManyToOne");
                    field.addAnnotation(String.format("@JoinColumn(left = \"%s\", right = \"%s\")", leftColumn.getActualColumnName(), rightTableColumn.getActualColumnName()));
                    topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.ManyToOne");
                    topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.JoinColumn");
                }
                field.setAttribute("FIELD_RELATION", (Object)builder.build());
                field.getJavaDocLines().clear();
                GeneratorUtils.addComment((JavaElement)field, field.getDescription());
                topLevelClass.addField(field);
            }
            Method method = JavaBeansUtil.getJavaBeansGetterWithGeneratedAnnotation((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)rightTable, (CompilationUnit)topLevelClass);
            if (this.context.getPlugins().modelGetterMethodGenerated(method, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) {
                topLevelClass.addMethod(method);
            }
            if (rightTable.isImmutable()) continue;
            method = JavaBeansUtil.getJavaBeansSetterWithGeneratedAnnotation((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)rightTable, (CompilationUnit)topLevelClass);
            if (!this.context.getPlugins().modelSetterMethodGenerated(method, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) continue;
            topLevelClass.addMethod(method);
        }
        List joinTables = joinEntry.getJoinTables();
        for (JoinTable joinTable : joinTables) {
            rightTable = GeneratorUtils.getIntrospectedTable(this.context, joinTable.getRightTable());
            IntrospectedTable middleTable = GeneratorUtils.getIntrospectedTable(this.context, joinTable.getMiddleTable());
            FullyQualifiedJavaType targetBindType = new FullyQualifiedJavaType(rightTable.getBaseRecordType());
            IntrospectedColumn introspectedColumn = new IntrospectedColumn();
            introspectedColumn.setJavaProperty(joinTable.getProperty());
            introspectedColumn.setContext(this.context);
            introspectedColumn.setIntrospectedTable(rightTable);
            introspectedColumn.setFullyQualifiedJavaType(new FullyQualifiedJavaType(rightTable.getBaseRecordType()));
            introspectedColumn.setActualColumnName("");
            FullyQualifiedJavaType listJavaType = FullyQualifiedJavaType.getNewListInstance();
            listJavaType.addTypeArgument(targetBindType);
            topLevelClass.addImportedType(listJavaType);
            Field field = new Field(joinTable.getProperty(), listJavaType);
            field.setAttribute("FIELD_RELATION", (Object)true);
            if (!this.context.getPlugins().modelFieldGenerated(field, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) continue;
            Relation.Builder builder = Relation.builder();
            builder.joinType(JoinTarget.JoinType.MANY_TO_MANY);
            field.setVisibility(JavaVisibility.PRIVATE);
            field.setAttribute("FIELD_RELATION", (Object)builder.build());
            field.addAnnotation("@ManyToMany");
            field.addAnnotation(String.format("@JoinTable(name = \"%s\", joinColumn = @JoinColumn(left = \"%s\", right = \"%s\"), inverseJoinColumn = @JoinColumn(left = \"%s\", right = \"%s\"))", middleTable.getFullyQualifiedTableNameAtRuntime(), joinTable.getJoinColumn().getLeft(), joinTable.getJoinColumn().getRight(), joinTable.getInverseJoinColumn().getLeft(), joinTable.getInverseJoinColumn().getRight()));
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.ManyToMany");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.JoinTable");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.JoinColumn");
            topLevelClass.addField(field);
        }
    }
}

