/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.entframework.kernel.db.generator.plugin.server.LombokAnnotation;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class EntityEnhancedPlugin
extends PluginAdapter {
    private final Collection<LombokAnnotation> annotations = new TreeSet<LombokAnnotation>();

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addDataAnnotation(topLevelClass, true);
        this.addFieldEnhancedMethod(topLevelClass);
        return true;
    }

    private void addFieldEnhancedMethod(TopLevelClass topLevelClass) {
        List fieldList = topLevelClass.getFields();
        fieldList.forEach(field -> {
            Method method = new Method(field.getName());
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setReturnType(topLevelClass.getType());
            Parameter parameter = new Parameter(field.getType(), field.getName());
            method.addParameter(parameter);
            method.addBodyLine(String.format("this.%s = %s;", field.getName(), field.getName()));
            method.addBodyLine("return this;");
            topLevelClass.addMethod(method);
        });
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addDataAnnotation(topLevelClass, false);
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addDataAnnotation(topLevelClass, true);
        return true;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return true;
    }

    public boolean dynamicSqlSupportGenerated(TopLevelClass supportClass, IntrospectedTable introspectedTable) {
        String baseRecordType = introspectedTable.getBaseRecordType();
        return true;
    }

    private void addDataAnnotation(TopLevelClass topLevelClass, boolean builder) {
        for (LombokAnnotation annotation : this.annotations) {
            if (!builder && "builder".equals(annotation.getParamName())) continue;
            topLevelClass.addImportedType(annotation.getJavaType());
            topLevelClass.addAnnotation(annotation.getName());
        }
    }

    public void initialized(IntrospectedTable introspectedTable) {
        this.annotations.add(LombokAnnotation.DATA);
        if (StringUtils.isNotEmpty((CharSequence)this.context.getJavaModelGeneratorConfiguration().getProperty("rootClass"))) {
            this.annotations.add(LombokAnnotation.EqualsAndHashCode);
        }
        this.annotations.add(LombokAnnotation.NO_ARGS_CONSTRUCTOR);
        this.annotations.add(LombokAnnotation.ALL_ARGS_CONSTRUCTOR);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String paramName;
            LombokAnnotation annotation;
            boolean isEnable = Boolean.parseBoolean(entry.getValue().toString());
            if (!isEnable || (annotation = LombokAnnotation.getValueOf(paramName = entry.getKey().toString().trim())) == null) continue;
            this.annotations.add(annotation);
            this.annotations.addAll(LombokAnnotation.getDependencies(annotation));
        }
        String baseRecordType = introspectedTable.getBaseRecordType();
        introspectedTable.setMyBatisDynamicSqlSupportType(baseRecordType + "_");
    }
}

