/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.generator;

import net.entframework.kernel.db.generator.plugin.generator.RestMethod;
import net.entframework.kernel.db.generator.plugin.generator.RestMethodAndImports;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Parameter;

public class WebRestMethodsGenerator {
    private final RestMethodAndImports.Builder builder = new RestMethodAndImports.Builder();
    private final FullyQualifiedJavaType recordType;
    private final FullyQualifiedJavaType voJavaType;
    private final String serviceFieldName;
    private FullyQualifiedJavaType baseVoType;
    private final IntrospectedColumn pkColumn;
    private final boolean addAnnotation;

    public WebRestMethodsGenerator(FullyQualifiedJavaType recordType, FullyQualifiedJavaType voJavaType, String serviceFieldName, IntrospectedColumn pkColumn, boolean addAnnotation) {
        this.recordType = recordType;
        this.voJavaType = voJavaType;
        this.serviceFieldName = serviceFieldName;
        this.pkColumn = pkColumn;
        this.addAnnotation = addAnnotation;
    }

    public RestMethodAndImports generate() {
        this.addCreateMethod();
        this.addUpdateMethod();
        this.addQueryListMethod();
        this.addPageListMethod();
        this.addDeleteByPrimaryKeyMethod();
        this.addBatchDeleteMethod();
        this.addSelectByPrimaryKeyMethod();
        if (this.baseVoType != null) {
            this.builder.withImport(this.baseVoType);
        }
        return this.builder.build();
    }

    public void setBaseVoType(FullyQualifiedJavaType baseRequestType) {
        this.baseVoType = baseRequestType;
    }

    public RestMethodAndImports build() {
        return this.builder.build();
    }

    public RestMethodAndImports.Builder getBuilder() {
        return this.builder;
    }

    public void addCreateMethod() {
        RestMethod method = new RestMethod("insert", "POST", this.recordType);
        method.setUrl("/create");
        method.setOperation("\u65b0\u589e");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(this.voJavaType);
        this.builder.withImport(this.voJavaType);
        Parameter parameter = new Parameter(this.voJavaType, "vo");
        if (this.addAnnotation) {
            parameter.addAnnotation("@RequestBody");
            parameter.addAnnotation(String.format("@Validated(%s.add.class)", this.baseVoType == null ? this.voJavaType.getShortName() : this.baseVoType.getShortName()));
            this.builder.withImport("org.springframework.web.bind.annotation.RequestBody");
            this.builder.withImport("org.springframework.validation.annotation.Validated");
        }
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }

    public void addBatchCreateMethod() {
        RestMethod method = new RestMethod("insertMultiple", "POST", this.recordType);
        method.setUrl("/batch-create");
        method.setOperation("\u6279\u91cf\u65b0\u589e");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(this.voJavaType);
        this.builder.withImport(this.voJavaType);
        FullyQualifiedJavaType responseBodyWrapperListType = FullyQualifiedJavaType.getNewListInstance();
        responseBodyWrapperListType.addTypeArgument(this.voJavaType);
        method.setReturnType(responseBodyWrapperListType);
        FullyQualifiedJavaType paramListType = FullyQualifiedJavaType.getNewListInstance();
        paramListType.addTypeArgument(this.voJavaType);
        this.builder.withImport(paramListType);
        Parameter parameter = new Parameter(paramListType, "voList");
        if (this.addAnnotation) {
            parameter.addAnnotation("@RequestBody");
            this.builder.withImport("org.springframework.web.bind.annotation.RequestBody");
        }
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }

    public void addUpdateMethod() {
        RestMethod method = new RestMethod("update", "POST", this.recordType);
        method.setOperation("\u66f4\u65b0-by PK");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(this.voJavaType);
        Parameter parameter = new Parameter(this.voJavaType, "vo");
        if (this.addAnnotation) {
            parameter.addAnnotation("@RequestBody");
            parameter.addAnnotation(String.format("@Validated(%s.update.class)", this.baseVoType == null ? this.voJavaType.getShortName() : this.baseVoType.getShortName()));
        }
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }

    public void addDeleteByPrimaryKeyMethod() {
        RestMethod method = new RestMethod("delete", "POST", this.recordType);
        method.setUrl("/delete");
        method.setOperation("\u5220\u9664-by PK");
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType responseJavaType = new FullyQualifiedJavaType("Integer");
        method.setReturnType(responseJavaType);
        Parameter parameter = new Parameter(this.voJavaType, "vo");
        if (this.addAnnotation) {
            parameter.addAnnotation("@RequestBody");
            parameter.addAnnotation(String.format("@Validated(%s.delete.class)", this.baseVoType == null ? this.voJavaType.getShortName() : this.baseVoType.getShortName()));
        }
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }

    public void addBatchDeleteMethod() {
        RestMethod method = new RestMethod("batchDelete", "POST", this.recordType);
        method.setOperation("\u6279\u91cf\u5220\u9664-by PK");
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType responseJavaType = new FullyQualifiedJavaType("Integer");
        FullyQualifiedJavaType responseBodyWrapperListType = FullyQualifiedJavaType.getNewListInstance();
        responseBodyWrapperListType.addTypeArgument(this.voJavaType);
        method.setReturnType(responseJavaType);
        Parameter parameter = new Parameter(responseBodyWrapperListType, "voList");
        if (this.addAnnotation) {
            parameter.addAnnotation("@RequestBody");
            parameter.addAnnotation(String.format("@Validated(%s.batchDelete.class)", this.baseVoType == null ? this.voJavaType.getShortName() : this.baseVoType.getShortName()));
        }
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }

    public void addQueryListMethod() {
        RestMethod method = new RestMethod("list", "GET", this.recordType);
        method.setOperation("\u5217\u8868");
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType responseBodyWrapperListType = FullyQualifiedJavaType.getNewListInstance();
        responseBodyWrapperListType.addTypeArgument(this.voJavaType);
        method.setReturnType(responseBodyWrapperListType);
        this.builder.withImport(responseBodyWrapperListType);
        Parameter parameter = new Parameter(this.voJavaType, "vo");
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }

    public void addPageListMethod() {
        RestMethod method = new RestMethod("page", "GET", this.recordType);
        method.setOperation("\u5206\u9875\u67e5\u8be2");
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType pageResultType = new FullyQualifiedJavaType("net.entframework.kernel.db.api.pojo.page.PageResult");
        this.builder.withImport(pageResultType);
        pageResultType.addTypeArgument(this.voJavaType);
        method.setReturnType(pageResultType);
        Parameter parameter = new Parameter(this.voJavaType, "vo");
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }

    public void addSelectByPrimaryKeyMethod() {
        RestMethod method = new RestMethod("load", "GET", this.recordType);
        method.setUrl("/detail");
        method.setOperation("\u83b7\u53d6\u8bb0\u5f55-by PK");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(this.voJavaType);
        Parameter parameter = new Parameter(this.voJavaType, "vo");
        if (this.addAnnotation) {
            parameter.addAnnotation(String.format("@Validated(%s.detail.class)", this.baseVoType == null ? this.voJavaType.getShortName() : this.baseVoType.getShortName()));
        }
        method.addParameter(parameter);
        this.builder.withMethod(method);
    }
}

