/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.generator;

import java.util.List;
import net.entframework.kernel.db.generator.plugin.generator.FieldAndImports;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;

public class VoFieldsGenerator {
    private final Context context;
    private final String codingStyle;
    private final String voTargetPackage;
    private String voSuffix = "";
    private final FullyQualifiedJavaType factory;

    public VoFieldsGenerator(Context context, String codingStyle, String voTargetPackage, String voSuffix, FullyQualifiedJavaType factory) {
        this.context = context;
        this.codingStyle = codingStyle;
        this.voTargetPackage = voTargetPackage;
        this.voSuffix = voSuffix;
        this.factory = factory;
    }

    public FieldAndImports generateVo(TopLevelClass modelClass, IntrospectedTable introspectedTable) {
        String modelObjectName = modelClass.getType().getShortNameWithoutTypeArguments();
        FieldAndImports.Builder builder = new FieldAndImports.Builder();
        List fields = modelClass.getFields();
        for (Field field : fields) {
            InnerEnum innerEnum;
            if ("serialVersionUID".equals(field.getName()) || GeneratorUtils.isLogicDeleteField(field)) continue;
            Field pojoRequestField = new Field(field);
            pojoRequestField.getAnnotations().clear();
            FullyQualifiedJavaType fieldType = field.getType();
            if (GeneratorUtils.isRelationField(introspectedTable, field)) {
                fieldType = this.getActualJavaType(field);
            }
            if ((innerEnum = (InnerEnum)field.getAttribute("TABLE_ENUM_FIELD_ATTR")) != null) {
                FullyQualifiedJavaType modelJavaType = GeneratorUtils.getModelJavaType(this.context, modelObjectName, this.factory);
                fieldType = this.factory.create(modelJavaType.getFullyQualifiedName() + "." + field.getType());
                builder.withImport(fieldType);
            }
            pojoRequestField.setType(fieldType);
            pojoRequestField.setVisibility(JavaVisibility.PRIVATE);
            if (field.getAttribute("FIELD_LOGIC_DELETE_ATTR") != null) {
                pojoRequestField.setAttribute("FIELD_LOGIC_DELETE_ATTR", field.getAttribute("FIELD_LOGIC_DELETE_ATTR"));
            }
            String fieldDescription = field.getDescription();
            if (GeneratorUtils.isRelationField(introspectedTable, field)) {
                builder.withImport(fieldType);
                pojoRequestField.setAttribute("FIELD_RELATION", field.getAttribute("FIELD_RELATION"));
            } else {
                builder.withImport(fieldType);
                IntrospectedColumn column = GeneratorUtils.getIntrospectedColumnByJavaProperty(introspectedTable, field.getName());
                if (GeneratorUtils.isPrimaryKey(introspectedTable, column)) {
                    if (column.isNumberColumn()) {
                        pojoRequestField.addAnnotation(String.format("@NotNull(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\", groups = {update.class, delete.class, detail.class, updateStatus.class})", fieldDescription));
                        builder.withImport("jakarta.validation.constraints.NotNull");
                    } else if (column.isStringColumn()) {
                        pojoRequestField.addAnnotation(String.format("@NotBlank(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\", groups = {update.class, delete.class, detail.class, updateStatus.class})", fieldDescription));
                        builder.withImport("jakarta.validation.constraints.NotBlank");
                    }
                } else if (!column.isNullable() && column.isStringColumn()) {
                    pojoRequestField.addAnnotation(String.format("@NotBlank(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\", groups = {add.class, update.class})", fieldDescription));
                    builder.withImport("jakarta.validation.constraints.NotBlank");
                }
            }
            if (this.codingStyle.equals("ENT")) {
                pojoRequestField.addAnnotation(String.format("@Description(\"%s\")", fieldDescription));
                builder.withImport("net.entframework.kernel.core.annotation.Description");
            }
            builder.withField(pojoRequestField);
        }
        return builder.build();
    }

    private FullyQualifiedJavaType getActualJavaType(Field field) {
        String fieldTypeName = field.getType().getFullyQualifiedNameWithoutTypeParameters();
        if ("java.util.List".equals(fieldTypeName)) {
            FullyQualifiedJavaType fullyQualifiedJavaType = FullyQualifiedJavaType.getNewListInstance();
            List typeArgs = field.getType().getTypeArguments();
            if (typeArgs != null) {
                for (FullyQualifiedJavaType type : typeArgs) {
                    fullyQualifiedJavaType.addTypeArgument(this.getVoJavaType(type.getShortName()));
                }
            }
            return fullyQualifiedJavaType;
        }
        return this.getVoJavaType(field.getType().getShortName());
    }

    public FullyQualifiedJavaType getVoJavaType(String modelObjectName) {
        return this.factory.create(this.voTargetPackage + "." + modelObjectName + this.voSuffix);
    }
}

