/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.generator;

import java.util.List;
import net.entframework.kernel.db.generator.plugin.generator.FieldAndImports;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.utils.Inflection;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;

public class PojoFieldsGenerator {
    private final Context context;
    private final String codingStyle;
    private final String pojoRequestTargetPackage;
    private String pojoRequestSuffix = "";
    private final String pojoResponseTargetPackage;
    private String pojoResponseSuffix = "";
    private final FullyQualifiedJavaType factory;

    public PojoFieldsGenerator(Context context, String codingStyle, String pojoRequestTargetPackage, String pojoRequestSuffix, String pojoResponseTargetPackage, String pojoResponseSuffix, FullyQualifiedJavaType factory) {
        this.context = context;
        this.codingStyle = codingStyle;
        this.pojoRequestTargetPackage = pojoRequestTargetPackage;
        this.pojoRequestSuffix = pojoRequestSuffix;
        this.pojoResponseTargetPackage = pojoResponseTargetPackage;
        this.pojoResponseSuffix = pojoResponseSuffix;
        this.factory = factory;
    }

    public FieldAndImports generatePojoRequest(TopLevelClass modelClass, IntrospectedTable introspectedTable) {
        String modelObjectName = modelClass.getType().getShortNameWithoutTypeArguments();
        FieldAndImports.Builder builder = new FieldAndImports.Builder();
        List fields = modelClass.getFields();
        for (Field field : fields) {
            InnerEnum innerEnum;
            if ("serialVersionUID".equals(field.getName()) || GeneratorUtils.isLogicDeleteField(field)) continue;
            Field pojoRequestField = new Field(field);
            pojoRequestField.getAnnotations().clear();
            FullyQualifiedJavaType fieldType = field.getType();
            if (GeneratorUtils.isRelationField(introspectedTable, field)) {
                fieldType = this.getActualJavaType(field, true);
            }
            if ((innerEnum = (InnerEnum)field.getAttribute("TABLE_ENUM_FIELD_ATTR")) != null) {
                FullyQualifiedJavaType modelJavaType = GeneratorUtils.getModelJavaType(this.context, modelObjectName, this.factory);
                fieldType = this.factory.create(modelJavaType.getFullyQualifiedName() + "." + field.getType());
                builder.withImport(fieldType);
            }
            pojoRequestField.setType(fieldType);
            pojoRequestField.setVisibility(JavaVisibility.PRIVATE);
            if (field.getAttribute("FIELD_LOGIC_DELETE_ATTR") != null) {
                pojoRequestField.setAttribute("FIELD_LOGIC_DELETE_ATTR", field.getAttribute("FIELD_LOGIC_DELETE_ATTR"));
            }
            String fieldDescription = field.getDescription();
            if (GeneratorUtils.isRelationField(introspectedTable, field)) {
                builder.withImport(fieldType);
                pojoRequestField.setAttribute("FIELD_RELATION", field.getAttribute("FIELD_RELATION"));
            } else {
                builder.withImport(fieldType);
                IntrospectedColumn column = GeneratorUtils.getIntrospectedColumnByJavaProperty(introspectedTable, field.getName());
                if (GeneratorUtils.isPrimaryKey(introspectedTable, column)) {
                    if (column.isNumberColumn()) {
                        pojoRequestField.addAnnotation(String.format("@NotNull(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\", groups = {update.class, delete.class, detail.class, updateStatus.class})", fieldDescription));
                        builder.withImport("jakarta.validation.constraints.NotNull");
                    } else if (column.isStringColumn()) {
                        pojoRequestField.addAnnotation(String.format("@NotBlank(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\", groups = {update.class, delete.class, detail.class, updateStatus.class})", fieldDescription));
                        builder.withImport("jakarta.validation.constraints.NotBlank");
                    }
                } else if (!column.isNullable() && column.isStringColumn()) {
                    pojoRequestField.addAnnotation(String.format("@NotBlank(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\", groups = {add.class, update.class})", fieldDescription));
                    builder.withImport("jakarta.validation.constraints.NotBlank");
                }
            }
            if (this.codingStyle.equals("ENT")) {
                pojoRequestField.addAnnotation(String.format("@Description(\"%s\")", fieldDescription));
                builder.withImport("net.entframework.kernel.core.annotation.Description");
            }
            builder.withField(pojoRequestField);
        }
        IntrospectedColumn pk = GeneratorUtils.getPrimaryKey(introspectedTable);
        String pluralizeIds = Inflection.pluralize(pk.getJavaProperty());
        FullyQualifiedJavaType fqjt = FullyQualifiedJavaType.getNewListInstance();
        fqjt.addTypeArgument(pk.getFullyQualifiedJavaType());
        Field pluralizeField = new Field(pluralizeIds, fqjt);
        pluralizeField.setVisibility(JavaVisibility.PRIVATE);
        pluralizeField.addAnnotation("@NotNull(message = \"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\", groups = {batchDelete.class})");
        if (this.codingStyle.equals("ENT")) {
            pluralizeField.addAnnotation(String.format("@Description(\"%s\")", "ID\u96c6\u5408"));
            builder.withImport("net.entframework.kernel.core.annotation.Description");
        }
        pluralizeField.setDescription("ID\u96c6\u5408");
        pluralizeField.setAttribute("FIELD_EXT_ATTR", (Object)true);
        builder.withField(pluralizeField);
        return builder.build();
    }

    public FieldAndImports generatePojoResponse(TopLevelClass modelClass, IntrospectedTable introspectedTable) {
        String modelObjectName = modelClass.getType().getShortNameWithoutTypeArguments();
        FieldAndImports.Builder builder = new FieldAndImports.Builder();
        List fields = modelClass.getFields();
        for (Field field : fields) {
            InnerEnum innerEnum;
            if ("serialVersionUID".equals(field.getName()) || GeneratorUtils.isLogicDeleteField(field)) continue;
            Field pojoResponseField = new Field(field);
            pojoResponseField.getAnnotations().clear();
            FullyQualifiedJavaType fieldType = field.getType();
            if (GeneratorUtils.isRelationField(introspectedTable, field)) {
                fieldType = this.getActualJavaType(field, false);
            }
            if ((innerEnum = (InnerEnum)field.getAttribute("TABLE_ENUM_FIELD_ATTR")) != null) {
                FullyQualifiedJavaType modelJavaType = GeneratorUtils.getModelJavaType(this.context, modelObjectName, this.factory);
                fieldType = this.factory.create(modelJavaType.getFullyQualifiedName() + "." + field.getType());
                builder.withImport(fieldType);
            }
            pojoResponseField.setType(fieldType);
            pojoResponseField.setVisibility(JavaVisibility.PRIVATE);
            if (GeneratorUtils.isRelationField(introspectedTable, field)) {
                builder.withImport(fieldType);
            } else {
                builder.withImport(field.getType());
            }
            String fieldDescription = field.getDescription();
            if (this.codingStyle.equals("ENT")) {
                pojoResponseField.addAnnotation(String.format("@Description(\"%s\")", fieldDescription));
                builder.withImport("net.entframework.kernel.core.annotation.Description");
            }
            builder.withField(pojoResponseField);
        }
        return builder.build();
    }

    private FullyQualifiedJavaType getActualJavaType(Field field, boolean isRequest) {
        String fieldTypeName = field.getType().getFullyQualifiedNameWithoutTypeParameters();
        if ("java.util.List".equals(fieldTypeName)) {
            FullyQualifiedJavaType fullyQualifiedJavaType = FullyQualifiedJavaType.getNewListInstance();
            List typeArgs = field.getType().getTypeArguments();
            if (typeArgs != null) {
                for (FullyQualifiedJavaType type : typeArgs) {
                    fullyQualifiedJavaType.addTypeArgument(isRequest ? this.getPojoRequestJavaType(type.getShortName()) : this.getPojoResponseJavaType(type.getShortName()));
                }
            }
            return fullyQualifiedJavaType;
        }
        return isRequest ? this.getPojoRequestJavaType(field.getType().getShortName()) : this.getPojoResponseJavaType(field.getType().getShortName());
    }

    public FullyQualifiedJavaType getPojoRequestJavaType(String modelObjectName) {
        return this.factory.create(this.pojoRequestTargetPackage + "." + modelObjectName + this.pojoRequestSuffix);
    }

    public FullyQualifiedJavaType getPojoResponseJavaType(String modelObjectName) {
        return this.factory.create(this.pojoResponseTargetPackage + "." + modelObjectName + this.pojoResponseSuffix);
    }
}

