/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.VerboseProgressCallback;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.codegen.mybatis3.javamapper.elements.AbstractJavaMapperMethodGenerator;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JoinEntry;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.runtime.dynamic.sql.elements.FragmentGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodParts;

public class IgnoreInsertMethodJavaMapperGenerator
extends AbstractJavaMapperMethodGenerator {
    private static final String MYBATIS3_CUSTOM_UTILS = "net.entframework.kernel.db.mybatis.util.MyBatis3CustomUtils";
    private final String tableFieldName;
    private final FragmentGenerator fragmentGenerator;
    private final FullyQualifiedJavaType recordType;
    private final String resultMapId;

    public IgnoreInsertMethodJavaMapperGenerator(Context context, IntrospectedTable table) {
        this.context = context;
        this.introspectedTable = table;
        this.progressCallback = new VerboseProgressCallback();
        this.warnings = new ArrayList();
        this.resultMapId = JoinEntry.getJoinResultMapId((String)this.introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        this.tableFieldName = JavaBeansUtil.getValidPropertyName((String)this.introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        this.recordType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType());
        this.fragmentGenerator = new FragmentGenerator.Builder().withIntrospectedTable(this.introspectedTable).withResultMapId(this.resultMapId).withTableFieldName(this.tableFieldName).build();
    }

    public void addInterfaceElements(Interface interfaze) {
        MethodAndImports defaultIgnoreInsertMethodAndImports;
        MethodAndImports ignoreInsertMethodAndImports = this.generateIgnoreInsertMethodAndImports();
        if (ignoreInsertMethodAndImports != null) {
            interfaze.addMethod(ignoreInsertMethodAndImports.getMethod());
            interfaze.addImportedTypes(ignoreInsertMethodAndImports.getImports());
            interfaze.addStaticImports(ignoreInsertMethodAndImports.getStaticImports());
        }
        if ((defaultIgnoreInsertMethodAndImports = this.generateDefaultIgnoreInsertMethodAndImports()) != null) {
            interfaze.addMethod(defaultIgnoreInsertMethodAndImports.getMethod());
            interfaze.addImportedTypes(defaultIgnoreInsertMethodAndImports.getImports());
            interfaze.addStaticImports(defaultIgnoreInsertMethodAndImports.getStaticImports());
        }
    }

    private MethodAndImports generateIgnoreInsertMethodAndImports() {
        if (!this.introspectedTable.getRules().generateSelectByExampleWithBLOBs() && !this.introspectedTable.getRules().generateSelectByExampleWithoutBLOBs()) {
            return null;
        }
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.insert.render.InsertStatementProvider");
        parameterType.addTypeArgument(this.recordType);
        FullyQualifiedJavaType adapter = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.SqlProviderAdapter");
        FullyQualifiedJavaType annotation = new FullyQualifiedJavaType("org.apache.ibatis.annotations.InsertProvider");
        FullyQualifiedJavaType options = new FullyQualifiedJavaType("org.apache.ibatis.annotations.Options");
        imports.add(parameterType);
        imports.add(adapter);
        imports.add(annotation);
        imports.add(options);
        imports.add(FullyQualifiedJavaType.getNewListInstance());
        imports.add(this.recordType);
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance();
        returnType.addTypeArgument(this.recordType);
        Method method = new Method("ignoreInsert");
        method.setAbstract(true);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(parameterType, "insertStatement"));
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.addAnnotation("@InsertProvider(type = SqlProviderAdapter.class, method = \"insert\")");
        if (this.introspectedTable.getGeneratedKey().isPresent()) {
            method.addAnnotation("@Options(useGeneratedKeys = true, keyProperty = \"row.id\")");
        } else {
            method.addAnnotation("@Options(useGeneratedKeys = false, keyProperty = \"row.id\")");
        }
        MethodAndImports.Builder builder = MethodAndImports.withMethod((Method)method).withImports(imports);
        if (this.introspectedTable.isConstructorBased()) {
            MethodParts methodParts = this.fragmentGenerator.getAnnotatedConstructorArgs();
            this.acceptParts(builder, method, methodParts);
        }
        return builder.build();
    }

    private MethodAndImports generateDefaultIgnoreInsertMethodAndImports() {
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        boolean reuseResultMap = this.introspectedTable.getRules().generateSelectByExampleWithBLOBs() || this.introspectedTable.getRules().generateSelectByExampleWithoutBLOBs();
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType(MYBATIS3_CUSTOM_UTILS);
        returnType.addTypeArgument(this.recordType);
        imports.add(returnType);
        imports.add(this.recordType);
        Method method = new Method("ignoreInsert");
        method.setDefault(true);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(this.recordType, "row"));
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        MethodAndImports.Builder builder = MethodAndImports.withMethod((Method)method).withImports(imports);
        builder.withImport(new FullyQualifiedJavaType(MYBATIS3_CUSTOM_UTILS));
        method.addBodyLine("return MyBatis3CustomUtils.ignoreInsert(this::ignoreInsert, row, " + this.tableFieldName + ", c ->");
        List columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns((List)this.introspectedTable.getAllColumns());
        boolean first = true;
        for (IntrospectedColumn column : columns) {
            String fieldName = column.getJavaProperty();
            if (column.isSequenceColumn()) {
                if (first) {
                    method.addBodyLine("    c.map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
                    first = false;
                    continue;
                }
                method.addBodyLine("    .map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
                continue;
            }
            String methodName = JavaBeansUtil.getGetterMethodName((String)column.getJavaProperty(), (FullyQualifiedJavaType)column.getFullyQualifiedJavaType());
            if (first) {
                method.addBodyLine("    c.map(" + fieldName + ").toPropertyWhenPresent(\"" + column.getJavaProperty() + "\", row::" + methodName + ")");
                first = false;
                continue;
            }
            method.addBodyLine("    .map(" + fieldName + ").toPropertyWhenPresent(\"" + column.getJavaProperty() + "\", row::" + methodName + ")");
        }
        method.addBodyLine(");");
        return builder.build();
    }

    private void acceptParts(MethodAndImports.Builder builder, Method method, MethodParts methodParts) {
        for (Parameter parameter : methodParts.getParameters()) {
            method.addParameter(parameter);
        }
        for (String annotation : methodParts.getAnnotations()) {
            method.addAnnotation(annotation);
        }
        method.addBodyLines((Collection)methodParts.getBodyLines());
        builder.withImports(methodParts.getImports());
    }
}

