/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.maven.MyBatisGeneratorMojo;

public class MavenShellCallback
extends DefaultShellCallback {
    private MyBatisGeneratorMojo mybatisGeneratorMojo;

    public MavenShellCallback(MyBatisGeneratorMojo mybatisGeneratorMojo, boolean overwrite) {
        super(overwrite);
        this.mybatisGeneratorMojo = mybatisGeneratorMojo;
    }

    public File getDirectory(GeneratedFile file) throws ShellException {
        if (StringUtils.isNotBlank((CharSequence)file.getOutputDirectory())) {
            Path path = Path.of(file.getOutputDirectory(), new String[0]);
            if (path.isAbsolute()) {
                return this.getDirectory(path.toAbsolutePath().toString(), file.getTargetProject(), file.getTargetPackage());
            }
            path = Path.of(this.mybatisGeneratorMojo.getOutputDirectory().getAbsolutePath(), file.getOutputDirectory());
            return this.getDirectory(path.toAbsolutePath().toString(), file.getTargetProject(), file.getTargetPackage());
        }
        return this.getDirectory(this.mybatisGeneratorMojo.getOutputDirectory().getAbsolutePath(), file.getTargetProject(), file.getTargetPackage());
    }

    private File getDirectory(String outputDirectory, String targetProject, String targetPackage) throws ShellException {
        boolean rc;
        File project = new File(outputDirectory);
        if (!project.exists()) {
            project.mkdirs();
        }
        if (!project.isDirectory()) {
            throw new ShellException(Messages.getString((String)"Warning.9", (Object[])new Object[]{project.getAbsolutePath()}));
        }
        StringBuilder sb = new StringBuilder();
        if ("MAVEN".equals(targetProject)) {
            sb.append("src/main/java/");
        } else {
            sb.append(targetProject);
            if (!StringUtils.endsWith((CharSequence)targetProject, (CharSequence)"/")) {
                sb.append("/");
            }
        }
        StringTokenizer st = new StringTokenizer(targetPackage, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(File.separatorChar);
        }
        File directory = new File(project, sb.toString());
        if (!directory.isDirectory() && !(rc = directory.mkdirs())) {
            throw new ShellException(Messages.getString((String)"Warning.10", (Object[])new Object[]{directory.getAbsolutePath()}));
        }
        return directory;
    }
}

