/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.gradle.dsl.MybatisGeneratorExtension;
import org.mybatis.generator.gradle.tasks.GradleLogFactory;
import org.mybatis.generator.gradle.tasks.GradleProgressCallback;
import org.mybatis.generator.gradle.tasks.GradleShellCallback;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.ClassloaderUtility;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.logging.AbstractLogFactory;
import org.mybatis.generator.logging.LogFactory;

@DisableCachingByDefault(because="Application should always run")
public class GeneratorJavaExec
extends ConventionTask {
    private final ThreadLocal<ClassLoader> savedClassloader = new ThreadLocal();

    @TaskAction
    public void exec() {
        Project project = this.getProject();
        MybatisGeneratorExtension extension = (MybatisGeneratorExtension)project.getExtensions().getByType(MybatisGeneratorExtension.class);
        if (!StringUtility.stringHasValue((String)extension.getConfigFile())) {
            throw new GradleException("mybatisGenerator config doesn't exist.");
        }
        String configFileLocation = extension.getConfigFile();
        File configFile = new File(configFileLocation);
        if (!configFile.exists() || !configFile.isFile()) {
            throw new GradleException("Generator XML config file doesn't exist.");
        }
        if (project.getLogger().isDebugEnabled()) {
            project.getLogger().debug(extension.toString());
        }
        System.setProperty("javax.xml.accessExternalDTD", "all");
        this.saveClassLoader();
        LogFactory.setLogFactory((AbstractLogFactory)new GradleLogFactory(project));
        this.calculateClassPath(project);
        ArrayList resourceDirectories = new ArrayList();
        ClassLoader cl = ClassloaderUtility.getCustomClassloader(resourceDirectories);
        ObjectFactory.addExternalClassLoader((ClassLoader)cl);
        ArrayList warnings = new ArrayList();
        HashSet<String> fullyqualifiedTables = new HashSet<String>();
        if (StringUtility.stringHasValue((String)extension.getTableNames())) {
            StringTokenizer st = new StringTokenizer(extension.getTableNames(), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.isEmpty()) continue;
                fullyqualifiedTables.add(s);
            }
        }
        HashSet<String> contextsToRun = new HashSet<String>();
        if (StringUtility.stringHasValue((String)extension.getContexts())) {
            StringTokenizer st = new StringTokenizer(extension.getContexts(), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.isEmpty()) continue;
                contextsToRun.add(s);
            }
        }
        if (project.getProperties().get("mb.context") != null && StringUtils.isNotBlank((CharSequence)project.getProperties().get("mb.context").toString())) {
            contextsToRun.clear();
            contextsToRun.add(project.getProperties().get("mb.context").toString());
        }
        if (project.getProperties().get("mb.outputDirectory") != null && StringUtils.isNotBlank((CharSequence)project.getProperties().get("mb.outputDirectory").toString())) {
            extension.setOutputDirectory(project.getProperties().get("mb.outputDirectory").toString());
        }
        try {
            ConfigurationParser cp = new ConfigurationParser(this.convertMapToProperty(project.getProperties(), extension), warnings);
            Configuration config = cp.parseConfiguration(configFile);
            GradleShellCallback callback = new GradleShellCallback(this, extension);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            myBatisGenerator.generate((ProgressCallback)new GradleProgressCallback(project.getLogger(), extension.getVerbose()), contextsToRun, fullyqualifiedTables);
        }
        catch (InvalidConfigurationException | XMLParserException e) {
            for (String error : e.getErrors()) {
                project.getLogger().error(error);
            }
            throw new GradleException(e.getMessage());
        }
        catch (IOException | SQLException e) {
            throw new GradleException(e.getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (String error : warnings) {
            project.getLogger().warn(error);
        }
        this.restoreClassLoader();
    }

    private void calculateClassPath(Project project) {
        HashSet entries = new HashSet();
        try {
            org.gradle.api.artifacts.Configuration defaultApiConfiguration = project.getConfigurations().getByName("runtimeClasspath");
            DependencySet dependencies = defaultApiConfiguration.getAllDependencies();
            dependencies.forEach(dependency -> {
                Set jarLocations = defaultApiConfiguration.files(new Dependency[]{dependency});
                jarLocations.forEach(file -> entries.add(file.getAbsolutePath()));
            });
            org.gradle.api.artifacts.Configuration configuration = project.getConfigurations().getByName("generator");
            dependencies = configuration.getDependencies();
            dependencies.forEach(dependency -> {
                Set jarLocations = configuration.files(new Dependency[]{dependency});
                jarLocations.forEach(file -> entries.add(file.getAbsolutePath()));
            });
            ClassLoader contextClassLoader = ClassloaderUtility.getCustomClassloader(entries);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Exception e) {
            throw new GradleException("Dependency Resolution Required", (Throwable)e);
        }
    }

    private Properties convertMapToProperty(Map<String, ?> properties, MybatisGeneratorExtension extension) {
        if (properties == null) {
            return new Properties();
        }
        Properties props = new Properties();
        properties.forEach((key, value) -> {
            if (key != null && value != null) {
                props.put(key, value);
            }
        });
        if (extension.getProperties() != null) {
            props.putAll((Map<?, ?>)extension.getProperties());
        }
        return props;
    }

    private void saveClassLoader() {
        this.savedClassloader.set(Thread.currentThread().getContextClassLoader());
    }

    private void restoreClassLoader() {
        Thread.currentThread().setContextClassLoader(this.savedClassloader.get());
        this.savedClassloader.remove();
    }
}

