/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.gradle.plugin;

import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.mybatis.generator.gradle.dsl.MybatisGeneratorExtension;
import org.mybatis.generator.gradle.plugin.MybatisGeneratorAction;
import org.mybatis.generator.gradle.plugin.PluginApplicationAction;

public class MybatisGeneratorPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getLogger().info("Configuring Mybatis Generator for project: {}", (Object)project.getName());
        this.verifyGradleVersion();
        this.createExtension(project);
        this.createConfiguration(project);
        this.registerPluginActions(project);
    }

    private void verifyGradleVersion() {
        GradleVersion currentVersion = GradleVersion.current();
        if (currentVersion.compareTo(GradleVersion.version((String)"7.4")) < 0) {
            throw new GradleException("Spring Boot plugin requires Gradle 7.x (7.4 or later). The current version is " + currentVersion);
        }
    }

    private void createExtension(Project project) {
        project.getExtensions().create("mybatisGenerator", MybatisGeneratorExtension.class, new Object[]{project});
    }

    private void createConfiguration(Project project) {
        project.getConfigurations().create("generator", c -> {
            c.setVisible(false);
            c.setCanBeConsumed(false);
            c.setCanBeResolved(true);
            c.setDescription("The data artifacts to be processed for this plugin.");
        });
    }

    private void registerPluginActions(Project project) {
        List<MybatisGeneratorAction> actions = List.of(new MybatisGeneratorAction());
        for (PluginApplicationAction pluginApplicationAction : actions) {
            this.withPluginClassOfAction(pluginApplicationAction, pluginClass -> project.getPlugins().withType(pluginClass, plugin -> action.execute(project)));
        }
    }

    private void withPluginClassOfAction(PluginApplicationAction action, Consumer<Class<? extends Plugin<? extends Project>>> consumer) {
        Class<? extends Plugin<? extends Project>> pluginClass;
        try {
            pluginClass = action.getPluginClass();
        }
        catch (Throwable ex) {
            return;
        }
        consumer.accept(pluginClass);
    }
}

