/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.mybatis.apt;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import net.entframework.mybatis.apt.AnnotationMeta;
import net.entframework.mybatis.apt.ColumnMeta;
import net.entframework.mybatis.apt.Utils;

@SupportedAnnotationTypes(value={"jakarta.persistence.Entity"})
public class MybatisProcessor
extends AbstractProcessor {
    public static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    public static final String PERSISTENCE_COLUMN_NAME = "jakarta.persistence.Column";
    public static final String SQL_COLUMN_NAME = "org.mybatis.dynamic.sql.annotation.SqlColumn";
    private Elements elementUtils;
    private static final Map<TypeElement, List<AnnotationMeta>> entityMap = new LinkedHashMap<TypeElement, List<AnnotationMeta>>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (!roundEnv.processingOver()) {
            Types types = this.processingEnv.getTypeUtils();
            Set<TypeElement> mappers = this.getMappers(annotations, roundEnv);
            mappers.forEach(typeElement -> {
                List<AnnotationMeta> fields = this.getFields((TypeElement)typeElement);
                TypeMirror superclass = typeElement.getSuperclass();
                while (superclass != null) {
                    Element typesElement = types.asElement(superclass);
                    if (typesElement instanceof TypeElement) {
                        TypeElement supper = (TypeElement)typesElement;
                        if (supper.getAnnotation(MappedSuperclass.class) == null) {
                            fields.addAll(this.getFields(supper));
                        }
                        superclass = supper.getSuperclass();
                        continue;
                    }
                    superclass = null;
                }
                entityMap.put((TypeElement)typeElement, fields);
            });
            Filer filer = this.processingEnv.getFiler();
            entityMap.forEach((key, value) -> this.writeSupportFile(filer, (TypeElement)key, (List<AnnotationMeta>)value));
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Mybatis Entity Support start");
        return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
    }

    private void writeSupportFile(Filer filer, TypeElement type, List<AnnotationMeta> fields) {
        PackageElement packageElement = this.elementUtils.getPackageOf(type);
        String packageName = packageElement.getQualifiedName().toString();
        TypeSpec.Builder clazzBuilder = TypeSpec.classBuilder((String)(type.getSimpleName() + "_")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        String typeName = type.getSimpleName().toString();
        String uncapitalizeName = Utils.uncapitalize(typeName);
        clazzBuilder.addField(FieldSpec.builder((TypeName)ClassName.get((String)"", (String)typeName, (String[])new String[0]), (String)uncapitalizeName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $N()", new Object[]{typeName}).build());
        ArrayList<String> fieldsList = new ArrayList<String>();
        fields.forEach(element -> {
            String fieldName = element.fieldName();
            fieldsList.add(fieldName);
            ClassName columnType = ClassName.get((String)"org.mybatis.dynamic.sql", (String)"SqlColumn", (String[])new String[0]);
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)columnType, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)element.asType())});
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)parameterizedTypeName, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC});
            fieldBuilder.initializer("$N.$N", new Object[]{uncapitalizeName, fieldName});
            clazzBuilder.addField(fieldBuilder.build());
        });
        FieldSpec selectList = FieldSpec.builder((TypeName)ArrayTypeName.of((TypeName)ClassName.get((String)"org.mybatis.dynamic.sql", (String)"BasicColumn", (String[])new String[0])), (String)"selectList", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("BasicColumn.columnList($N)", new Object[]{Utils.join(fieldsList, ", ")}).build();
        clazzBuilder.addField(selectList);
        TypeSpec.Builder innerBuilder = TypeSpec.classBuilder((String)typeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        ClassName supperSqlTable = ClassName.get((String)"org.mybatis.dynamic.sql", (String)"AliasableSqlTable", (String[])new String[0]);
        innerBuilder.superclass((TypeName)ParameterizedTypeName.get((ClassName)supperSqlTable, (TypeName[])new TypeName[]{TypeVariableName.get((String)typeName)}));
        fields.forEach(element -> {
            String fieldName = element.fieldName();
            ClassName columnType = ClassName.get((String)"org.mybatis.dynamic.sql", (String)"SqlColumn", (String[])new String[0]);
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)columnType, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)element.asType())});
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)parameterizedTypeName, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            try {
                ColumnMeta columnMeta = this.getColumnMeta((AnnotationMeta)element);
                fieldBuilder.initializer("column(\"$N\", $T.$N)", new Object[]{columnMeta.getColumnName(), JDBCType.class, columnMeta.getJdbcType().getName()});
            }
            catch (Exception exception) {
                // empty catch block
            }
            innerBuilder.addField(fieldBuilder.build());
        });
        String tableName = this.getTableName(type);
        MethodSpec constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(\"$N\", $N::new)", new Object[]{tableName, typeName}).build();
        innerBuilder.addMethod(constructorBuilder);
        clazzBuilder.addType(innerBuilder.build());
        TypeSpec clazz = clazzBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)clazz).build();
        String className = type.getQualifiedName().toString() + "_";
        try (Writer writer = filer.createSourceFile(className, type).openWriter();){
            javaFile.writeTo((Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ColumnMeta getColumnMeta(AnnotationMeta element) {
        Map<String, Object> sqlColumnData;
        ColumnMeta columnMeta = new ColumnMeta();
        Map<String, Object> columnData = element.getAnnotationData(PERSISTENCE_COLUMN_NAME);
        if (columnData != null) {
            String name = (String)columnData.getOrDefault("name", element.fieldName());
            columnMeta.setColumnName(name);
        }
        if ((sqlColumnData = element.getAnnotationData(SQL_COLUMN_NAME)) != null) {
            Object jdbcType = sqlColumnData.get("jdbcType");
            if (jdbcType instanceof JDBCType) {
                columnMeta.setJdbcType((JDBCType)jdbcType);
            } else if (jdbcType instanceof Element) {
                System.out.println(jdbcType);
            }
        } else {
            System.out.println("Can't get jdbcType from :" + element.fieldName());
        }
        return columnMeta;
    }

    private String getTableName(TypeElement type) {
        String result = type.getSimpleName().toString();
        Table table = type.getAnnotation(Table.class);
        if (table != null) {
            return table.name();
        }
        return result;
    }

    private List<AnnotationMeta> getFields(TypeElement typeElement) {
        ArrayList<AnnotationMeta> results = new ArrayList<AnnotationMeta>();
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        enclosedElements.forEach(element -> {
            if (element.getKind() == ElementKind.FIELD && !element.getModifiers().contains((Object)Modifier.STATIC) && element instanceof VariableElement) {
                VariableElement variableElement = (VariableElement)element;
                List<? extends AnnotationMirror> elementAnnotationMirrors = variableElement.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : elementAnnotationMirrors) {
                    System.out.println(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName());
                    Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                    elementValues.forEach((key, value) -> System.out.println(key.getSimpleName() + ": " + value.getValue()));
                }
                AnnotationMeta annotationMeta = new AnnotationMeta(variableElement);
                if (annotationMeta.hasAnnotation(PERSISTENCE_COLUMN_NAME) && annotationMeta.hasAnnotation(SQL_COLUMN_NAME)) {
                    results.add(annotationMeta);
                }
            }
        });
        return results;
    }

    private Set<TypeElement> getMappers(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        HashSet<TypeElement> mapperTypes = new HashSet<TypeElement>();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Entity.class)) {
            TypeElement mapperTypeElement = this.asTypeElement(element);
            if (mapperTypeElement == null) continue;
            mapperTypes.add(mapperTypeElement);
        }
        return mapperTypes;
    }

    private TypeElement asTypeElement(Element element) {
        return element.accept(new ElementKindVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitTypeAsInterface(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitTypeAsClass(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    private void handleUncaughtError(Element element, Throwable thrown) {
        StringWriter sw = new StringWriter();
        thrown.printStackTrace(new PrintWriter(sw));
        String reportableStacktrace = sw.toString();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error in the mybatis processor: " + reportableStacktrace, element);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("jakarta.persistence.Entity");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

