/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.mybatis.apt;

import java.sql.JDBCType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

class AnnotationMeta {
    private static final Map<String, Map<String, Object>> annotationData = new ConcurrentHashMap<String, Map<String, Object>>();
    private final VariableElement element;

    public AnnotationMeta(VariableElement variableElement) {
        this.element = variableElement;
        List<? extends AnnotationMirror> elementAnnotationMirrors = variableElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : elementAnnotationMirrors) {
            System.out.println(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName());
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            LinkedHashMap keyValueMap = new LinkedHashMap();
            elementValues.forEach((key, value) -> {
                Object gValue = value.getValue();
                if (gValue instanceof VariableElement) {
                    JDBCType accepted = value.accept(new MyAnnotationValueVisitor(), null);
                    if (accepted != null) {
                        keyValueMap.put(key.getSimpleName().toString(), accepted);
                    }
                } else {
                    keyValueMap.put(key.getSimpleName().toString(), gValue);
                }
            });
            annotationData.put(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString(), keyValueMap);
        }
    }

    public Map<String, Object> getAnnotationData(String annoName) {
        return annotationData.get(annoName);
    }

    public boolean hasAnnotation(String annoName) {
        return annotationData.containsKey(annoName);
    }

    public String fieldName() {
        return this.element.getSimpleName().toString();
    }

    public TypeMirror asType() {
        return this.element.asType();
    }

    public static class MyAnnotationValueVisitor
    extends SimpleAnnotationValueVisitor8<JDBCType, Void> {
        @Override
        public JDBCType visitEnumConstant(VariableElement c, Void unused) {
            return JDBCType.valueOf(c.getSimpleName().toString());
        }
    }
}

