package net.emaze.tinytypes;

import java.io.Serializable;

/**
 *
 * @author rferranti
 */
public abstract class BooleanTinyType implements Serializable, Comparable<BooleanTinyType> {

    public final boolean value;

    protected BooleanTinyType(boolean value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.format("%s#%s", this.getClass().getSimpleName(), value);
    }

    @Override
    public int compareTo(BooleanTinyType other) {
        return Boolean.compare(this.value, other.value);
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs.getClass() != this.getClass()) {
            return false;
        }
        final BooleanTinyType other = (BooleanTinyType) rhs;
        return this.value == other.value;
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(value);
    }

}
