/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation.invocation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.e6tech.elements.common.federation.Frequency;
import net.e6tech.elements.common.federation.Member;
import net.e6tech.elements.common.federation.Registry;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.concurrent.Async;
import net.e6tech.elements.network.cluster.Local;
import net.e6tech.elements.web.federation.CollectiveImpl;
import net.e6tech.elements.web.federation.Service;
import net.e6tech.elements.web.federation.invocation.AsyncImpl;
import net.e6tech.elements.web.federation.invocation.InvokerRegistry;
import net.e6tech.elements.web.federation.invocation.InvokerRegistryAPI;

public class InvokerRegistryImpl
implements InvokerRegistry,
Initializable {
    private static Cache<String, Set<String>> cache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(100L).expireAfterWrite(600000L, TimeUnit.MILLISECONDS).build();
    private CollectiveImpl collective;
    private ConcurrentMap<String, Function<Object[], Object>> registrations = new ConcurrentHashMap<String, Function<Object[], Object>>();
    private volatile int roundRobin = new Random().nextInt(0x3FFFFFFF);
    private Executor executor = runnable -> new Thread(runnable).start();

    @Override
    public void start() {
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor != null ? executor : runnable -> new Thread(runnable).start();
    }

    public CollectiveImpl getCollective() {
        return this.collective;
    }

    public void setCollective(CollectiveImpl collective) {
        this.collective = collective;
        InvokerRegistryAPI api = new InvokerRegistryAPI();
        api.setRegistry(this);
        api.setSubZero(collective.getSubZero());
        Service<InvokerRegistryImpl, InvokerRegistryAPI> service = new Service<InvokerRegistryImpl, InvokerRegistryAPI>(this, InvokerRegistryAPI.class, api);
        collective.addService(service);
    }

    @Override
    public void shutdown() {
    }

    public void initialize(Resources resources) {
        if (this.collective == null) {
            throw new IllegalStateException("Federation not set.");
        }
    }

    protected String register(String path, Function<Object[], Object> invoker) {
        this.registrations.put(path, invoker);
        return path;
    }

    public synchronized <T> List<String> register(String qualifier, Class<T> interfaceClass, T implementation) {
        return this.register(qualifier, interfaceClass, implementation, null);
    }

    @Override
    public synchronized <T> List<String> register(String qualifier, Class<T> interfaceClass, T implementation, InvocationHandler customizedInvoker) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass " + interfaceClass.getName() + " needs to be an interface.");
        }
        if (!Modifier.isPublic(interfaceClass.getModifiers())) {
            throw new IllegalArgumentException("interfaceClass " + interfaceClass.getName() + " needs to be public.");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Method method : interfaceClass.getMethods()) {
            String methodName;
            Local local = method.getAnnotation(Local.class);
            if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            if (implementation == null) {
                list.add(this.register(this.fullyQualify(qualifier, interfaceClass, method), null));
                continue;
            }
            if (customizedInvoker == null) {
                customizedInvoker = (target, meth, args) -> meth.invoke(target, args);
            }
            InvocationHandler invoker = customizedInvoker;
            list.add(this.register(this.fullyQualify(qualifier, interfaceClass, method), args -> {
                try {
                    return invoker.invoke(implementation, method, (Object[])args);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new SystemException(e);
                }
            }));
        }
        for (Member m : this.collective.getHostedMembers().values()) {
            cache.invalidate((Object)m.getMemberId());
        }
        return list;
    }

    String fullyQualify(String qualifier, Class interfaceClass, Method method) {
        return Registry.fullyQualify((String)qualifier, (Class)interfaceClass, (Method)method);
    }

    @Override
    public <R> Function<Object[], CompletableFuture<R>> route(String qualifier, Class interfaceClass, Method method, Registry.Routing routing) {
        String path = this.fullyQualify(qualifier, interfaceClass, method);
        Collection<Frequency> frequencies = this.collective.frequencies();
        LinkedList<Frequency> applicable = new LinkedList<Frequency>();
        for (Frequency f : frequencies) {
            Set<String> paths = this.routes(f);
            if (!paths.contains(path)) continue;
            applicable.add(f);
        }
        if (applicable.isEmpty()) {
            throw new NotAvailableException("No route for path=" + path);
        }
        return args -> {
            if (routing != Registry.Routing.local) {
                if (this.roundRobin == 0x3FFFFFFF) {
                    this.roundRobin = 0;
                }
                ++this.roundRobin;
            }
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
                if (routing == Registry.Routing.local) {
                    for (int i = 0; i < applicable.size(); ++i) {
                        Frequency frequency = (Frequency)applicable.get(i);
                        if (!this.collective.getHostedMembers().containsKey(frequency.memberId())) continue;
                        InvokerRegistry registry = this.collective.getServiceProvider(InvokerRegistry.class);
                        return registry.invoke(path, (Object[])args);
                    }
                }
                int select = this.roundRobin % applicable.size();
                for (int i = 0; i < applicable.size(); ++i) {
                    InvokerRegistryAPI.Request request;
                    Frequency frequency = (Frequency)applicable.get(select);
                    if (this.collective.getHostedMembers().containsKey(frequency.memberId()) && routing == Registry.Routing.remote && i < applicable.size() - 1) continue;
                    if (this.collective.getHostedMembers().containsKey(frequency.memberId())) {
                        InvokerRegistry registry = this.collective.getServiceProvider(InvokerRegistry.class);
                        return registry.invoke(path, (Object[])args);
                    }
                    InvokerRegistryAPI api = (InvokerRegistryAPI)frequency.getService(InvokerRegistryAPI.class);
                    InvokerRegistryAPI.Response response = api.invoke(request = new InvokerRegistryAPI.Request(path, (Object[])args, this.collective.getSubZero()));
                    if (response == null) {
                        select = (select + 1) % applicable.size();
                        continue;
                    }
                    return this.collective.getSubZero().thaw(response.getFrozen());
                }
                throw new NotAvailableException("No service found for qualifier=" + qualifier + " class=" + interfaceClass + " method=" + method);
            }, this.executor);
            return future;
        };
    }

    private Set<String> routes(Frequency frequency) {
        Set<String> paths = (Set<String>)cache.getIfPresent((Object)frequency.memberId());
        if (paths == null) {
            paths = Collections.emptySet();
            InvokerRegistryAPI api = (InvokerRegistryAPI)frequency.getService(InvokerRegistryAPI.class);
            if (api != null) {
                try {
                    Set<String> routes = api.routes();
                    if (!routes.isEmpty()) {
                        cache.put((Object)frequency.memberId(), routes);
                    }
                    paths = routes;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return paths;
    }

    public Collection routes(String qualifier, Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        Collection<Frequency> frequencies = this.collective.frequencies();
        LinkedList<Frequency> applicable = new LinkedList<Frequency>();
        block0: for (Frequency f : frequencies) {
            for (Method method : interfaceClass.getMethods()) {
                String methodName;
                Local local = method.getAnnotation(Local.class);
                if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
                String path = this.fullyQualify(qualifier, interfaceClass, method);
                Set<String> paths = this.routes(f);
                if (!paths.contains(path)) continue;
                applicable.add(f);
                continue block0;
            }
        }
        return applicable;
    }

    @Override
    public Set<String> routes() {
        return this.registrations.keySet();
    }

    @Override
    public Object invoke(String path, Object[] arguments) {
        Function func = (Function)this.registrations.get(path);
        if (func == null) {
            throw new NotAvailableException("No service found for path=" + path);
        }
        return func.apply(arguments);
    }

    public <R> Async<R> async(String qualifier, Class<R> interfaceClass) {
        return new AsyncImpl<R>(this, qualifier, interfaceClass, this.collective.getReadTimeout(), this.executor);
    }

    public <R> Async<R> async(String qualifier, Class<R> interfaceClass, long timeout, Registry.Routing routing) {
        long t = timeout > 0L ? timeout : (long)this.collective.getReadTimeout();
        AsyncImpl<R> impl = new AsyncImpl<R>(this, qualifier, interfaceClass, t, this.executor);
        impl.setRouting(routing);
        return impl;
    }
}

