/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.lang.reflect.InvocationHandler;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import net.e6tech.elements.common.federation.Collective;
import net.e6tech.elements.common.federation.Frequency;
import net.e6tech.elements.common.federation.Member;
import net.e6tech.elements.common.federation.MemberListener;
import net.e6tech.elements.common.federation.Registry;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.notification.ShutdownNotification;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.subscribe.DefaultBroadcast;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.concurrent.Async;
import net.e6tech.elements.web.cxf.JaxRSLauncher;
import net.e6tech.elements.web.federation.AuthObserver;
import net.e6tech.elements.web.federation.Beacon;
import net.e6tech.elements.web.federation.BeaconAPI;
import net.e6tech.elements.web.federation.Event;
import net.e6tech.elements.web.federation.HailingFrequency;
import net.e6tech.elements.web.federation.Host;
import net.e6tech.elements.web.federation.Service;
import net.e6tech.elements.web.federation.SubZero;

public abstract class CollectiveImpl
implements Startable,
Collective,
Registry {
    protected static Logger logger = Logger.getLogger();
    protected Provision provision;
    protected String domainName;
    protected String hostAddress;
    protected String apiAddress;
    protected String[] seeds = new String[0];
    protected Map<String, Member> hostedMembers = new HashMap<String, Member>();
    private Map<String, Member> unmodifiableHosted = Collections.unmodifiableMap(this.hostedMembers);
    protected Beacon beacon;
    protected int fanout = 5;
    protected int cycle = 8;
    protected int eventCacheInitialCapacity = 10;
    protected long eventCacheExpire = 60000L;
    protected long seedRefreshInterval = 5000L;
    protected long eventInterval = 500L;
    protected long syncInterval = 120000L;
    protected Long renewalInterval = 10000L;
    protected Long renewalPadding = 30000L;
    protected Long deadMemberRenewalInterval = 900000L;
    protected int connectionTimeout = 15000;
    protected int readTimeout = 15000;
    protected JaxRSLauncher launcher;
    protected List<MemberListener> listeners = new LinkedList<MemberListener>();
    protected AuthObserver authObserver;
    protected List<Service> services = new LinkedList<Service>();
    protected Map<Class, Service> serviceMap = new LinkedHashMap<Class, Service>();
    private volatile boolean started = false;
    private SubZero subZero = new SubZero();
    private Executor executor = runnable -> new Thread(runnable).start();
    private DefaultBroadcast broadcast = new DefaultBroadcast(this.executor);

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Host[] getHosts() {
        Host[] hosts = new Host[this.hostedMembers.size()];
        int n = 0;
        for (Member m : this.hostedMembers.values()) {
            hosts[n] = new Host();
            hosts[n].setMemberId(m.getMemberId());
            hosts[n].setName(m.getName());
            ++n;
        }
        return hosts;
    }

    public void setHosts(Host[] hosts) {
        if (hosts == null) {
            this.hostedMembers.clear();
            return;
        }
        for (Host h : hosts) {
            this.addHostedMember(h.getMemberId(), h.getName());
        }
    }

    public Map<String, Member> getHostedMembers() {
        return this.unmodifiableHosted;
    }

    public CollectiveImpl addHostedMember(String memberId, String name) {
        Member member = new Member();
        member.setName(name);
        member.setMemberId(memberId);
        return this.addHostedMember(member);
    }

    public CollectiveImpl addHostedMember(String memberId) {
        Member member = new Member();
        member.setMemberId(memberId);
        return this.addHostedMember(member);
    }

    public CollectiveImpl addHostedMember(Member member) {
        this.refresh(member);
        this.hostedMembers.put(member.getMemberId(), member);
        if (this.launcher != null && this.launcher.isStarted()) {
            this.beacon.announce(member);
        }
        return this;
    }

    public String[] getSeeds() {
        return this.seeds;
    }

    public void setSeeds(String[] seeds) {
        this.seeds = seeds;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String address) {
        this.hostAddress = address.trim();
        while (this.hostAddress.endsWith("/")) {
            this.hostAddress = this.hostAddress.substring(0, this.hostAddress.length() - 1);
        }
    }

    public String getApiAddress() {
        return this.apiAddress;
    }

    public void setApiAddress(String apiAddress) {
        this.apiAddress = apiAddress.trim();
        while (apiAddress.endsWith("/")) {
            apiAddress = apiAddress.substring(0, apiAddress.length() - 1);
        }
    }

    public int getFanout() {
        return this.fanout;
    }

    public void setFanout(int fanout) {
        this.fanout = fanout;
    }

    public int getCycle() {
        return this.cycle;
    }

    public void setCycle(int cycle) {
        this.cycle = cycle;
    }

    public int getEventCacheInitialCapacity() {
        return this.eventCacheInitialCapacity;
    }

    public void setEventCacheInitialCapacity(int eventCacheInitialCapacity) {
        this.eventCacheInitialCapacity = eventCacheInitialCapacity;
    }

    public long getEventCacheExpire() {
        return this.eventCacheExpire;
    }

    public void setEventCacheExpire(long eventCacheExpire) {
        this.eventCacheExpire = eventCacheExpire;
    }

    public long getSeedRefreshInterval() {
        return this.seedRefreshInterval;
    }

    public void setSeedRefreshInterval(long seedRefreshInterval) {
        this.seedRefreshInterval = seedRefreshInterval;
    }

    public long getEventInterval() {
        return this.eventInterval;
    }

    public void setEventInterval(long eventInterval) {
        this.eventInterval = eventInterval;
    }

    public long getSyncInterval() {
        return this.syncInterval;
    }

    public void setSyncInterval(long syncInterval) {
        this.syncInterval = syncInterval;
    }

    public Long getRenewalInterval() {
        return this.renewalInterval;
    }

    public void setRenewalInterval(Long renewalInterval) {
        this.renewalInterval = renewalInterval;
    }

    public Long getRenewalPadding() {
        return this.renewalPadding;
    }

    public void setRenewalPadding(Long renewalPadding) {
        this.renewalPadding = renewalPadding;
    }

    public Long getDeadMemberRenewalInterval() {
        return this.deadMemberRenewalInterval;
    }

    public void setDeadMemberRenewalInterval(Long deadMemberRenewalInterval) {
        this.deadMemberRenewalInterval = deadMemberRenewalInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public abstract Type getType();

    public Collection<Member> members() {
        return this.beacon.members();
    }

    public Collection<Frequency> frequencies() {
        Collection<HailingFrequency> frequencies = this.beacon.frequencies().values();
        ArrayList<Frequency> list = new ArrayList<Frequency>(frequencies);
        return list;
    }

    public abstract void onEvent(@Nonnull Event var1);

    public void onAnnounced(@Nonnull Event event) {
    }

    public List<MemberListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<MemberListener> listeners) {
        this.listeners = listeners;
    }

    public void addListener(MemberListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MemberListener listener) {
        this.listeners.remove(listener);
    }

    public AuthObserver getAuthObserver() {
        return this.authObserver;
    }

    @Inject(optional=true)
    public void setAuthObserver(AuthObserver authObserver) {
        this.authObserver = authObserver;
    }

    public SubZero getSubZero() {
        return this.subZero;
    }

    public void setSubZero(SubZero subZero) {
        this.subZero = subZero;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Inject(optional=true)
    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.broadcast.setExecutor(executor);
    }

    public DefaultBroadcast getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(DefaultBroadcast broadcast) {
        this.broadcast = broadcast;
    }

    protected Member refresh(Member member) {
        long duration = this.getRenewalInterval() + (long)this.getCycle() * this.getEventInterval() + this.getRenewalPadding();
        member.setExpiration(System.currentTimeMillis() + duration);
        member.setAddress(this.getHostAddress());
        LinkedList serviceList = new LinkedList();
        this.services.forEach(rs -> serviceList.add(rs.getServiceClass().getName()));
        member.setServices(serviceList);
        return member;
    }

    public void start() {
        this.createLauncher();
        this.createServices();
        this.startServer();
        this.startBeacon();
        this.started = true;
        this.provision.getResourceManager().getNotificationCenter().addNotificationListener(ShutdownNotification.class, notification -> this.shutdown());
    }

    protected void createLauncher() {
        try {
            URL url;
            if (this.apiAddress != null) {
                url = new URL(this.apiAddress);
            } else {
                url = new URL(this.hostAddress);
                url = new URL(url.getProtocol(), "0.0.0.0", url.getPort(), url.getFile());
            }
            this.launcher = JaxRSLauncher.create(this.provision, url.toExternalForm()).headerObserver(this.authObserver);
        }
        catch (Exception ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void addService(Service service) {
        this.services.add(service);
    }

    public Service removeService(Class cls) {
        Iterator<Service> iterator = this.services.iterator();
        Service s = null;
        while (iterator.hasNext()) {
            Service service = iterator.next();
            if (!service.getServiceClass().equals(cls)) continue;
            iterator.remove();
            s = service;
        }
        return s;
    }

    public <T> T getServiceProvider(Class<T> cls) {
        Iterator<Service> iterator = this.services.iterator();
        Service s = null;
        while (iterator.hasNext()) {
            Service service = iterator.next();
            if (!cls.isAssignableFrom(service.getProvider().getClass())) continue;
            s = service;
            break;
        }
        return s != null ? (T)s.getProvider() : null;
    }

    protected void createServices() {
        if (this.hostAddress == null) {
            throw new IllegalStateException("hostAddress is null.");
        }
        if (this.cycle <= 0) {
            throw new IllegalStateException("cycle needs to be greater than 0.");
        }
        if (this.fanout <= 0) {
            throw new IllegalStateException("fanout needs to be greater than 0.");
        }
        this.hostedMembers.forEach((id, m) -> {
            if (m.getMemberId() == null) {
                throw new IllegalStateException("memberId is null.");
            }
            if (m.getName() == null) {
                m.setName(m.getMemberId());
            }
            if (!m.getMemberId().equals(id)) {
                throw new IllegalStateException("memberId does not match hostedMembers' key");
            }
        });
        this.setupBeacon();
        this.setupServices();
        LinkedList serviceList = new LinkedList();
        this.services.forEach(rs -> serviceList.add(rs.getServiceClass().getName()));
        this.beacon.seeds(this.seeds);
        this.hostedMembers.forEach((id, m) -> this.refresh((Member)m));
    }

    protected void setupBeacon() {
        this.beacon = new Beacon();
        this.beacon.setCollective(this);
        if (this.provision != null) {
            this.provision.inject((Object)this.beacon);
        }
        BeaconAPI prototype = new BeaconAPI();
        prototype.setCollective(this);
        Service<Beacon, BeaconAPI> beaconAPI = new Service<Beacon, BeaconAPI>(this.beacon, BeaconAPI.class, prototype);
        this.services.add(0, beaconAPI);
    }

    protected void setupServices() {
        this.services.forEach(s -> {
            if (s.getServiceClass() == null && s.getPrototype() == null) {
                return;
            }
            this.serviceMap.put(s.getServiceClass(), (Service)s);
            if (s.getPrototype() != null) {
                this.perInstanceService(s.getPrototype());
            } else {
                this.perInstanceService((Object)s.getServiceClass());
            }
        });
    }

    protected <T> void sharedService(Class<T> cls) {
        this.launcher.sharedService(cls);
    }

    protected <T> void perInstanceService(Class<T> cls) {
        this.launcher.perInstanceService(cls);
    }

    protected <T> void perInstanceService(T prototype) {
        this.launcher.perInstanceService(prototype);
    }

    protected void startServer() {
        this.launcher.start();
    }

    protected void startBeacon() {
        this.beacon.start();
    }

    public void shutdown() {
        if (!this.started) {
            return;
        }
        try {
            if (this.beacon != null) {
                this.beacon.shutdown();
            }
            if (this.launcher != null) {
                this.launcher.stop();
            }
            this.beacon = null;
            this.launcher = null;
        }
        catch (Exception ex) {
            logger.warn("Error shutting down collective with domain name=" + this.getDomainName(), (Throwable)ex);
        }
        finally {
            this.started = false;
        }
    }

    public void subscribe(String topic, Subscriber subscriber) {
        this.broadcast.subscribe(topic, subscriber);
    }

    public void unsubscribe(String topic, Subscriber subscriber) {
        this.broadcast.unsubscribe(topic, subscriber);
    }

    public void publish(Notice<?> notice) {
        if (!notice.isExternalOnly()) {
            this.publishInternal(notice);
        }
        this.beacon.broadcast(notice);
    }

    public Notice publishInternal(Notice<?> notice) {
        this.broadcast.publish(notice);
        return notice;
    }

    public <T> List<String> register(String qualifier, Class<T> interfaceClass, T implementation) {
        return this.getRegistry().register(qualifier, interfaceClass, implementation);
    }

    public <T> List<String> register(String qualifier, Class<T> interfaceClass, T implementation, InvocationHandler invoker) {
        return this.getRegistry().register(qualifier, interfaceClass, implementation, invoker);
    }

    public Collection routes(String qualifier, Class interfaceClass) {
        return this.getRegistry().routes(qualifier, interfaceClass);
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass) {
        return this.getRegistry().async(qualifier, interfaceClass);
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass, long timeout, Registry.Routing routing) {
        return this.getRegistry().async(qualifier, interfaceClass, timeout, routing);
    }

    public static enum Type {
        CLUSTER,
        FEDERATION;

    }
}

