/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation.invocation;

import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.web.federation.SubZero;
import net.e6tech.elements.web.federation.invocation.InvokerRegistry;

@Path(value="/v1/invoker-registry")
public class InvokerRegistryAPI {
    @Inject
    private Provision provision;
    private InvokerRegistry registry;
    private SubZero subZero;

    public InvokerRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(InvokerRegistry registry) {
        this.registry = registry;
    }

    public SubZero getSubZero() {
        return this.subZero;
    }

    public void setSubZero(SubZero subZero) {
        this.subZero = subZero;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="hosts")
    public Set<String> routes() {
        return this.registry.routes();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="invoke")
    public Response invoke(Request request) {
        if (!this.registry.routes().contains(request.path)) {
            return null;
        }
        Response response = new Response();
        try {
            Object ret = this.registry.invoke(request.path, request.thaw(this.subZero));
            response.setFrozen(this.subZero.freeze(ret));
        }
        catch (Exception ex) {
            response.setException(ex);
        }
        return response;
    }

    public static class Response {
        Exception exception;
        byte[] frozen;

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public byte[] getFrozen() {
            return this.frozen;
        }

        public void setFrozen(byte[] frozen) {
            this.frozen = frozen;
        }
    }

    public static class Request {
        private String path;
        private byte[] frozen;

        public Request() {
        }

        public Request(String path, Object[] arguments, SubZero subZero) {
            this.path = path;
            this.frozen = subZero.freeze(arguments);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public byte[] getFrozen() {
            return this.frozen;
        }

        public void setFrozen(byte[] frozen) {
            this.frozen = frozen;
        }

        public Object[] thaw(SubZero subZero) {
            if (this.frozen != null) {
                return (Object[])subZero.thaw(this.frozen);
            }
            return null;
        }
    }
}

