/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation.invocation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.federation.Registry;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.concurrent.Async;
import net.e6tech.elements.web.federation.invocation.InvokerRegistry;

public class AsyncImpl<U>
implements Async<U> {
    private Class<U> interfaceClass;
    private InvokerRegistry registry;
    private String qualifier;
    private long timeout;
    private final Executor executor;
    private U proxy;
    private CompletableFuture future;
    private Registry.Routing routing = Registry.Routing.random;

    public AsyncImpl(InvokerRegistry registry, String qualifier, Class<U> interfaceClass, long timeout, Executor executor) {
        this.registry = registry;
        this.qualifier = qualifier;
        this.timeout = timeout;
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        this.interfaceClass = interfaceClass;
        this.proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new MyHandler());
        this.executor = executor != null ? executor : runnable -> new Thread(runnable).start();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Registry.Routing getRouting() {
        return this.routing;
    }

    public void setRouting(Registry.Routing routing) {
        this.routing = routing;
    }

    public <R> CompletionStage<R> apply(Function<U, R> function) {
        this.future = null;
        function.apply(this.proxy);
        if (this.timeout > 0L) {
            return (CompletionStage)Interceptor.getInstance().newInterceptor((Object)this.future, (InterceptorHandler)new FutureHandler(this.timeout));
        }
        return this.future;
    }

    public CompletionStage<Void> accept(Consumer<U> consumer) {
        this.future = null;
        consumer.accept(this.proxy);
        if (this.timeout > 0L) {
            return (CompletionStage)Interceptor.getInstance().newInterceptor((Object)this.future, (InterceptorHandler)new FutureHandler(this.timeout));
        }
        return this.future;
    }

    private class FutureHandler
    implements InterceptorHandler {
        private long timeout;

        FutureHandler(long timeout) {
            this.timeout = timeout;
        }

        public Object invoke(CallFrame ctx) throws Throwable {
            Method method = ctx.getMethod();
            if ((method.getName().equals("get") || method.getName().equals("join")) && method.getParameterCount() == 0) {
                try {
                    AsyncImpl.this.future.get(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException ex) {
                    throw ExceptionMapper.unwrap((Throwable)ex.getCause());
                }
                catch (CancellationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw ExceptionMapper.unwrap((Throwable)ex);
                }
            } else if (method.getName().equals("toCompletableFuture") && method.getParameterCount() == 0) {
                return ctx.getProxyObject();
            }
            Object result = method.invoke(ctx.getTarget(), ctx.getArguments());
            if (result instanceof CompletableFuture) {
                return Interceptor.getInstance().newInterceptor(result, (InterceptorHandler)this);
            }
            return result;
        }
    }

    private class MyHandler
    implements InvocationHandler {
        private MyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return AsyncImpl.this.invoke(AsyncImpl.this, method, args, () -> {
                Function function = AsyncImpl.this.registry.route(AsyncImpl.this.qualifier, AsyncImpl.this.interfaceClass, method, AsyncImpl.this.routing);
                AsyncImpl.this.future = function.apply(args);
                return Primitives.defaultValue(method.getReturnType());
            });
        }
    }
}

