/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.e6tech.elements.common.federation.Frequency;
import net.e6tech.elements.common.federation.Member;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorListener;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.restful.RestfulProxy;
import net.e6tech.elements.web.federation.AuthObserver;
import net.e6tech.elements.web.federation.BeaconAPI;
import net.e6tech.elements.web.federation.CollectiveImpl;

public class HailingFrequency
implements Frequency {
    static Logger logger = Logger.getLogger();
    private Member member;
    private Map<Class, Object> services = new ConcurrentHashMap<Class, Object>();
    private CollectiveImpl collective;
    private long lastConnectionError = 0L;
    private int consecutiveError = 0;

    public HailingFrequency(Member member, CollectiveImpl federation) {
        this.collective = federation;
        this.setMember(member);
    }

    public HailingFrequency(String hostAddress, CollectiveImpl federation) {
        this.collective = federation;
        Member m = new Member();
        m.setMemberId("seed");
        m.setAddress(hostAddress);
        this.setMember(m);
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
        for (String serviceClass : member.getServices()) {
            this.createRemoteService(serviceClass);
        }
    }

    public long getLastConnectionError() {
        return this.lastConnectionError;
    }

    public int getConsecutiveError() {
        return this.consecutiveError;
    }

    private Object createRemoteService(String serviceClass) {
        RestfulProxy proxy = new RestfulProxy(this.member.getAddress());
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass(serviceClass);
            MyInterceptorListener listener = new MyInterceptorListener();
            listener.proxy = proxy;
            Object service = proxy.newProxy(cls, (InterceptorListener)listener);
            this.services.put(cls, service);
            proxy.getClient().setReadTimeout(this.collective.getReadTimeout());
            proxy.getClient().setConnectionTimeout(this.collective.getConnectionTimeout());
            return service;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public BeaconAPI beacon() {
        return this.getService(BeaconAPI.class);
    }

    public <T> T getService(Class<T> cls) {
        if (cls.equals(BeaconAPI.class) && !this.services.containsKey(cls)) {
            return (T)this.createRemoteService(BeaconAPI.class.getName());
        }
        return (T)(this.services.containsKey(cls) ? this.services.get(cls) : this.createRemoteService(cls.getName()));
    }

    public <T> T removeService(Class<T> cls) {
        return (T)this.services.remove(cls);
    }

    private class MyInterceptorListener
    implements InterceptorListener {
        RestfulProxy proxy;

        private MyInterceptorListener() {
        }

        public void preInvocation(CallFrame frame) {
            AuthObserver observer = HailingFrequency.this.collective.getAuthObserver();
            if (observer == null) {
                return;
            }
            observer.authorize(this.proxy);
        }

        public Object postInvocation(CallFrame frame, Object returnValue) {
            HailingFrequency.this.lastConnectionError = 0L;
            HailingFrequency.this.consecutiveError = 0;
            return returnValue;
        }

        public Object onException(CallFrame frame, Throwable throwable) {
            if (!(throwable instanceof ConnectException)) {
                logger.warn("Error executing " + frame.getMethod().getName() + " memberId=" + HailingFrequency.this.member.getMemberId() + " address=" + HailingFrequency.this.member.getAddress(), throwable);
            } else {
                HailingFrequency.this.lastConnectionError = System.currentTimeMillis();
                if (HailingFrequency.this.consecutiveError < 0x3FFFFFFF) {
                    HailingFrequency.this.consecutiveError++;
                }
            }
            throw new SystemException(throwable);
        }
    }
}

