/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import net.e6tech.elements.common.federation.Genesis;
import net.e6tech.elements.common.federation.Registration;
import net.e6tech.elements.common.federation.Registry;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.util.StringUtil;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.federation.ClusterImpl;
import net.e6tech.elements.web.federation.invocation.InvokerRegistry;
import net.e6tech.elements.web.federation.invocation.InvokerRegistryImpl;

public class GenesisImpl
implements Initializable,
Genesis {
    private ClusterImpl cluster = new ClusterImpl();
    private Provision provision;
    private List<Registration> registrations = new LinkedList<Registration>();
    private Configuration.Resolver resolver;

    public String getName() {
        return this.cluster.getDomainName();
    }

    public void setName(String name) {
        this.cluster.getDomainName();
    }

    public String getDomainName() {
        return this.cluster.getDomainName();
    }

    public void setDomainName(String name) {
        this.cluster.setDomainName(name);
    }

    public ClusterImpl getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterImpl cluster) {
        this.cluster = cluster;
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public List<Registration> getRegistrations() {
        return this.registrations;
    }

    public void setRegistrations(List<Registration> registrations) {
        this.registrations = registrations;
    }

    public Configuration.Resolver getResolver() {
        return this.resolver;
    }

    @Inject(optional=true)
    public void setResolver(Configuration.Resolver resolver) {
        this.resolver = resolver;
    }

    public void initialize(Resources resources) {
        if (!StringUtil.isNullOrEmpty((String)this.cluster.getHostAddress())) {
            InvokerRegistryImpl registry = (InvokerRegistryImpl)this.provision.newInstance(InvokerRegistryImpl.class);
            registry.setExecutor(this.provision.getExecutor());
            registry.setCollective(this.cluster);
            registry.initialize(null);
            this.provision.inject((Object)this.cluster);
            for (Registration reg : this.registrations) {
                Type[] types;
                if (this.resolver != null && reg.getImplementation() instanceof String) {
                    reg.setImplementation(this.resolver.resolve(reg.getImplementation().toString()));
                }
                if (reg.getInterfaceClass() != null) {
                    if (reg.getImplementation() != null) {
                        this.cluster.register(reg.getQualifier(), reg.getInterfaceClass(), reg.getImplementation());
                        continue;
                    }
                    try {
                        Type[] types2;
                        Object instance = reg.getInterfaceClass().newInstance();
                        Type[] typeArray = types2 = Module.load((Class)reg.getInterfaceClass());
                        int n = typeArray.length;
                        for (int i = 0; i < n; ++i) {
                            Type type = typeArray[i];
                            if (!(type instanceof Class) || !((Class)type).isInterface()) continue;
                            this.cluster.register(reg.getQualifier(), (Class)type, instance);
                        }
                        continue;
                    }
                    catch (InstantiationException e) {
                        throw new SystemException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new SystemException((Throwable)e);
                    }
                }
                if (reg.getImplementation() == null) continue;
                for (Type type : types = Module.load(reg.getImplementation().getClass())) {
                    if (!(type instanceof Class) || !((Class)type).isInterface()) continue;
                    this.cluster.register(reg.getQualifier(), (Class)type, reg.getImplementation());
                }
            }
            this.cluster.start();
            this.provision.getResourceManager().getNotificationCenter().addBroadcast((Broadcast)this.cluster);
        }
    }

    public Registry getRegistry() {
        return this.cluster.getServiceProvider(InvokerRegistry.class);
    }

    public void shutdown() {
        this.cluster.shutdown();
    }

    public CompletionStage<Void> async(Runnable runnable) {
        return CompletableFuture.runAsync(() -> runnable.run(), this.provision.getExecutor());
    }

    public <R> CompletionStage<R> async(Supplier<R> supplier) {
        return CompletableFuture.supplyAsync(() -> supplier.get(), this.provision.getExecutor());
    }
}

