/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.e6tech.elements.common.federation.Member;
import net.e6tech.elements.web.federation.CollectiveImpl;
import net.e6tech.elements.web.federation.Event;

@Path(value="/v1/beacon")
public class BeaconAPI {
    private CollectiveImpl collective;

    public CollectiveImpl getCollective() {
        return this.collective;
    }

    public void setCollective(CollectiveImpl collective) {
        this.collective = collective;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="hosts")
    public Collection<Member> hosts() {
        return this.collective.getHostedMembers().values();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="members")
    public Collection<Member> members() {
        return this.collective.members();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="events")
    public void onEvent(@Nonnull Event event) {
        this.collective.onEvent(event);
    }
}

