/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.e6tech.elements.common.federation.Frequency;
import net.e6tech.elements.common.federation.Member;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.web.federation.CollectiveImpl;
import net.e6tech.elements.web.federation.Event;
import net.e6tech.elements.web.federation.HailingFrequency;

public class Beacon {
    public static Logger logger = Logger.getLogger();
    private CollectiveImpl collective;
    private Cache<UUID, Event> events;
    private final Random random = new Random();
    private volatile boolean shutdown = false;
    private ReentrantLock seeding = new ReentrantLock();
    private List<HailingFrequency> seedFrequencies = Collections.emptyList();
    private Thread eventThread;
    private Map<String, HailingFrequency> frequencies = new ConcurrentHashMap<String, HailingFrequency>(128);

    public CollectiveImpl getCollective() {
        return this.collective;
    }

    public void setCollective(CollectiveImpl collective) {
        this.collective = collective;
    }

    protected void seeds(String[] seeds) {
        if (seeds == null) {
            this.seedFrequencies = Collections.emptyList();
            return;
        }
        ArrayList<HailingFrequency> list = new ArrayList<HailingFrequency>(seeds.length);
        for (String s : seeds) {
            list.add(new HailingFrequency(s, this.collective));
        }
        this.seedFrequencies = Collections.unmodifiableList(list);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public Collection<Member> members() {
        return this.frequencies.values().stream().map(HailingFrequency::getMember).collect(Collectors.toList());
    }

    protected int knownFrequencies() {
        return this.frequencies.size();
    }

    protected void trimFrequencies() {
        this.frequencies.values().removeIf(f -> !this.collective.getHostedMembers().containsKey(f.memberId()) && f.getMember().getExpiration() < System.currentTimeMillis());
    }

    public HailingFrequency getFrequency(String memberId) {
        return this.frequencies.get(memberId);
    }

    protected HailingFrequency updateFrequency(Member member) {
        HailingFrequency f = this.frequencies.get(member.getMemberId());
        if (f == null) {
            f = new HailingFrequency(member, this.collective);
            this.frequencies.put(member.getMemberId(), f);
            if (f.getMember().getExpiration() < member.getExpiration()) {
                f.setMember(member);
            }
            HailingFrequency f2 = f;
            this.collective.getExecutor().execute(() -> this.collective.getListeners().forEach(listener -> listener.added((Frequency)f2)));
        } else if (f.getMember().getExpiration() < member.getExpiration()) {
            f.setMember(member);
        }
        return f;
    }

    protected void updateFrequencies(Collection<Member> list) {
        for (Member member : list) {
            this.updateFrequency(member);
        }
    }

    protected void removeFrequency(HailingFrequency frequency) {
        if (frequency != null && !this.collective.getHostedMembers().containsKey(frequency.getMember().getMemberId())) {
            HailingFrequency c = this.frequencies.remove(frequency.memberId());
            this.collective.getExecutor().execute(() -> this.collective.getListeners().forEach(listener -> listener.removed((Frequency)c)));
        }
    }

    protected void removeFrequencies(Collection<Member> list) {
        for (Member member : list) {
            if (this.collective.getHostedMembers().containsKey(member.getMemberId())) continue;
            HailingFrequency c = this.frequencies.remove(member.getMemberId());
            this.collective.getExecutor().execute(() -> this.collective.getListeners().forEach(listener -> listener.removed((Frequency)c)));
        }
    }

    protected Map<String, HailingFrequency> frequencies() {
        HashMap<String, HailingFrequency> map = new HashMap<String, HailingFrequency>(this.frequencies);
        return Collections.unmodifiableMap(map);
    }

    public void start() {
        if (this.events != null) {
            this.events.invalidateAll();
            this.events.cleanUp();
        }
        this.events = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).initialCapacity(this.collective.getEventCacheInitialCapacity()).expireAfterAccess(this.collective.getEventCacheExpire(), TimeUnit.MILLISECONDS).build();
        this.shutdown = false;
        this.collective.getHostedMembers().values().forEach(m -> {
            this.collective.refresh((Member)m);
            this.updateFrequency((Member)m);
        });
        Thread thread = new Thread(this::run);
        thread.start();
    }

    private void run() {
        while (this.frequencies.size() == 0) {
            HailingFrequency frequency = this.frequencies.values().iterator().next();
            try {
                frequency.beacon().members();
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {}
            }
        }
        logger.trace("{} start seeding.", (Object)this.collective.getHostAddress());
        this.seeds("starting");
        logger.trace("{} done seeding.", (Object)this.collective.getHostAddress());
        this.eventThread = new Thread(this::events);
        this.eventThread.start();
        Thread sync = new Thread(this::sync);
        sync.start();
        try {
            Thread.sleep(this.collective.getRenewalInterval());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Thread renewal = new Thread(this::renewal);
        renewal.start();
    }

    private void seeds(String from) {
        if (!this.seeding.tryLock()) {
            return;
        }
        try {
            while (true) {
                if (this.seedFrequencies.isEmpty()) {
                    this.announce();
                    break;
                }
                if (this.syncMembers(this.seedFrequencies)) {
                    logger.trace("{} {} seeds announce ", (Object)this.collective.getHostAddress(), (Object)from);
                    this.announce();
                    break;
                }
                try {
                    Thread.sleep(this.collective.getSeedRefreshInterval());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.seeding.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event) {
        if (this.shutdown) {
            return;
        }
        Cache<UUID, Event> cache = this.events;
        synchronized (cache) {
            Event existing = (Event)this.events.getIfPresent((Object)event.getUuid());
            if (existing != null && existing != null && existing.getUuid().equals(event.getUuid())) {
                event.addVisited(existing.getVisited());
                if (event.getCycle() > existing.getCycle()) {
                    event.setCycle(existing.getCycle());
                }
                this.events.put((Object)event.getUuid(), (Object)event);
                return;
            }
        }
        logger.trace("{} onEvent: {}", (Object)this.collective.getHostAddress(), (Object)event);
        if (Objects.equals(event.getDomainName(), this.collective.getDomainName()) && event.getCollectiveType() == this.collective.getType()) {
            Notice notice;
            if (event.getType() == Event.Type.ANNOUNCE) {
                this.updateFrequencies(event.getMembers());
            } else if (event.getType() == Event.Type.REMOVE) {
                this.removeFrequencies(event.getMembers());
            } else if (event.getType() == Event.Type.BROADCAST && (notice = (Notice)this.collective.getSubZero().thaw(event.getPayload())) != null) {
                this.collective.publishInternal(notice);
            }
        }
        if (event.getCycle() > 0) {
            cache = this.events;
            synchronized (cache) {
                this.events.put((Object)event.getUuid(), (Object)event);
                HashSet<String> hostedMemberIds = new HashSet<String>(this.collective.getHostedMembers().size() * 2 + 1);
                this.collective.getHostedMembers().values().forEach(m -> hostedMemberIds.add(m.getMemberId()));
                event.addVisited(hostedMemberIds);
                event.getVisited().addAll(this.collective.getHostedMembers().keySet());
                this.events.notifyAll();
            }
        }
    }

    private void decrementCycle(Event event) {
        if (event.getCycle() > 0) {
            event.setCycle(event.getCycle() - 1);
        }
    }

    private void announce() {
        this.trimFrequencies();
        this.collective.getHostedMembers().values().forEach(this.collective::refresh);
        ArrayList<Member> list = new ArrayList<Member>(this.collective.getHostedMembers().size());
        list.addAll(this.collective.getHostedMembers().values());
        Event event = new Event(this.collective.getDomainName(), Event.Type.ANNOUNCE, this.collective.getType(), list, this.collective.getCycle());
        event.getVisited().addAll(this.collective.getHostedMembers().keySet());
        this.events.put((Object)event.getUuid(), (Object)event);
        this.collective.onAnnounced(event);
        this.gossip(event);
    }

    void announce(Member member) {
        this.collective.refresh(member);
        ArrayList<Member> list = new ArrayList<Member>();
        list.add(member);
        this.onEvent(new Event(this.collective.getDomainName(), Event.Type.ANNOUNCE, this.collective.getType(), list, this.collective.getCycle()));
    }

    void broadcast(Notice notice) {
        this.trimFrequencies();
        this.collective.getHostedMembers().values().forEach(this.collective::refresh);
        ArrayList<Member> list = new ArrayList<Member>(this.collective.getHostedMembers().size());
        list.addAll(this.collective.getHostedMembers().values());
        Event event = new Event(this.collective.getDomainName(), Event.Type.BROADCAST, this.collective.getType(), list, this.collective.getCycle());
        event.getVisited().addAll(this.collective.getHostedMembers().keySet());
        this.events.put((Object)event.getUuid(), (Object)event);
        event.setPayload(this.collective.getSubZero().freeze(notice));
        this.gossip(event);
    }

    private void renewal() {
        while (!this.shutdown) {
            try {
                long interval = this.collective.getRenewalInterval() + (long)this.collective.getCycle() * this.collective.getEventInterval();
                if (this.knownFrequencies() <= this.collective.getHostedMembers().size()) {
                    this.seeds("renewal");
                    Thread.sleep(interval);
                    continue;
                }
                long now = System.currentTimeMillis();
                logger.trace("{} renewal: ", (Object)this.collective.getHostAddress());
                this.announce();
                long sleep = interval - (System.currentTimeMillis() - now);
                if (sleep < 0L) {
                    sleep = this.collective.getRenewalInterval();
                }
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception ex) {
                logger.error("renewal", (Throwable)ex);
            }
        }
    }

    private void events() {
        while (!this.shutdown) {
            try {
                this.processEvents();
                Thread.sleep(this.collective.getEventInterval());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception ex) {
                logger.error("events", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        int after;
        int before;
        LinkedList copy = new LinkedList();
        Cache<UUID, Event> cache = this.events;
        synchronized (cache) {
            while (this.events.size() == 0L || this.knownFrequencies() <= this.collective.getHostedMembers().size()) {
                try {
                    this.events.wait();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            ConcurrentMap map = this.events.asMap();
            copy.addAll(map.values());
            copy.forEach(this::decrementCycle);
            before = copy.size();
            map.entrySet().removeIf(e -> ((Event)e.getValue()).getCycle() <= 0);
            after = copy.size();
        }
        logger.trace("{} event size {}, {}", new Object[]{this.collective.getHostAddress(), before, after});
        copy.forEach(this::gossip);
    }

    private void sync() {
        while (!this.shutdown) {
            try {
                if (this.knownFrequencies() >= this.collective.getHostedMembers().size()) {
                    this.syncMembers(this.frequencies().values());
                }
                Thread.sleep(this.collective.getSyncInterval());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception ex) {
                logger.error("sync", (Throwable)ex);
            }
        }
    }

    private boolean syncMembers(Collection<HailingFrequency> fList) {
        if (fList.isEmpty()) {
            return false;
        }
        List list = fList.stream().filter(c -> !this.collective.getHostedMembers().containsKey(c.memberId())).collect(Collectors.toList());
        long interval = this.collective.getRenewalInterval() + (long)this.collective.getCycle() * this.collective.getEventInterval();
        if ((list = list.stream().filter(c -> {
            boolean filter;
            boolean bl = filter = System.currentTimeMillis() - c.getLastConnectionError() > (long)c.getConsecutiveError() * interval;
            if (System.currentTimeMillis() - c.getLastConnectionError() > this.collective.getDeadMemberRenewalInterval()) {
                return true;
            }
            return filter;
        }).collect(Collectors.toList())).isEmpty()) {
            return true;
        }
        URL hostAddress = null;
        try {
            hostAddress = new URL(this.collective.getHostAddress());
        }
        catch (MalformedURLException e) {
            logger.warn("Invalid host address " + this.collective.getHostAddress());
            return false;
        }
        while (true) {
            HailingFrequency frequency = null;
            try {
                if (list.isEmpty()) {
                    return false;
                }
                int n = this.random.nextInt(list.size());
                frequency = (HailingFrequency)list.remove(n);
                URL memberURL = new URL(frequency.getMember().getAddress());
                if (hostAddress.equals(memberURL)) continue;
                Collection<Member> list2 = frequency.beacon().members();
                logger.trace("{} syncMembers: {}", (Object)this.collective.getHostAddress(), list2);
                this.updateFrequencies(list2);
                return true;
            }
            catch (Exception ex) {
                this.removeFrequency(frequency);
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        long now = System.currentTimeMillis();
        this.collective.getHostedMembers().values().forEach(m -> m.setExpiration(now));
        ArrayList<Member> list = new ArrayList<Member>(this.collective.getHostedMembers().size());
        list.addAll(this.collective.getHostedMembers().values());
        Event event = new Event(this.collective.getDomainName(), Event.Type.REMOVE, this.collective.getType(), list, this.collective.getCycle());
        event.getVisited().addAll(this.collective.getHostedMembers().keySet());
        for (Member member : list) {
            HailingFrequency c = this.frequencies.remove(member.getMemberId());
            this.collective.getExecutor().execute(() -> this.collective.getListeners().forEach(listener -> listener.removed((Frequency)c)));
        }
        this.gossip(event);
        if (this.eventThread != null) {
            this.eventThread.interrupt();
            this.eventThread = null;
        }
        if (this.events != null) {
            this.events.invalidateAll();
        }
    }

    private void gossip(Event event) {
        List chosen;
        List list = this.frequencies.values().stream().filter(c -> !event.getVisited().contains(c.memberId())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return;
        }
        int fanout = this.collective.getFanout();
        if (fanout >= list.size()) {
            chosen = list;
        } else {
            chosen = new ArrayList(fanout);
            for (int i = 0; i < fanout; ++i) {
                int n = this.random.nextInt(list.size());
                chosen.add(list.get(n));
                list.remove(n);
            }
        }
        this.collective.getExecutor().execute(() -> chosen.forEach(frequency -> {
            logger.trace("{} gossip to {} {}", new Object[]{this.collective.getHostAddress(), frequency.memberId(), event});
            try {
                frequency.beacon().onEvent(event);
            }
            catch (Exception ex) {
                this.removeFrequency((HailingFrequency)frequency);
            }
        }));
    }
}

