/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.e6tech.elements.common.federation.Cluster;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.federation.CollectiveImpl;
import net.e6tech.elements.web.federation.Event;
import net.e6tech.elements.web.federation.FederationImpl;

public class ClusterImpl
extends CollectiveImpl
implements Cluster {
    FederationImpl federation = new FederationImpl(this);

    public FederationImpl getFederation() {
        return this.federation;
    }

    public void setFederation(FederationImpl federation) {
        this.federation = federation;
        if (federation != null) {
            federation.setCluster(this);
        }
    }

    @Override
    public void setHostAddress(String address) {
        URL url;
        super.setHostAddress(address);
        try {
            url = new URL(address);
        }
        catch (MalformedURLException e) {
            throw new SystemException((Throwable)e);
        }
        this.addHostedMember(url.getHost() + ":" + url.getPort());
    }

    @Override
    public void start() {
        this.getFederation().setCluster(this);
        if (this.getHostAddress() != null) {
            if (this.federation != null) {
                this.federation.setCluster(this);
            }
            super.start();
        } else if (this.federation != null) {
            this.federation.setCluster(null);
        }
        if (this.federation != null && this.federation.getHostAddress() != null) {
            this.provision.inject((Object)this.federation);
            this.federation.setExecutor(this.getExecutor());
            this.federation.start();
        }
    }

    @Override
    public CollectiveImpl.Type getType() {
        return CollectiveImpl.Type.CLUSTER;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.federation != null) {
            this.federation.shutdown();
        }
    }

    @Override
    public void onEvent(@Nonnull Event event) {
        this.beacon.onEvent(event);
        if (this.federation != null && event.getCollectiveType() == CollectiveImpl.Type.FEDERATION) {
            this.federation.beacon.onEvent(event);
        }
    }
}

