/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.JaxRSServer;
import net.e6tech.elements.web.cxf.Observer;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.message.Message;

class SharedResourceProvider
extends SingletonResourceProvider {
    private static ThreadLocal<Message> messageThreadLocal = new ThreadLocal();
    private Observer observer;
    private Object proxy = null;
    private Map<Method, String> methods = new ConcurrentHashMap<Method, String>();
    private CXFServer server;

    SharedResourceProvider(JaxRSServer server, Object instance, Observer observer) {
        super(instance, true);
        this.server = server;
        this.observer = observer;
    }

    public Object getInstance(Message m) {
        Observer cloneObserver;
        messageThreadLocal.set(m);
        Observer observer = cloneObserver = this.observer != null ? this.observer.clone() : null;
        if (this.proxy == null) {
            this.proxy = this.server.getInterceptor().newInterceptor(super.getInstance(null), frame -> {
                Message message = messageThreadLocal.get();
                try {
                    this.server.checkInvocation(frame.getMethod(), frame.getArguments());
                    if (cloneObserver != null && message != null) {
                        Pair<HttpServletRequest, HttpServletResponse> pair = this.server.getServletRequestResponse(message);
                        this.server.getProvision().inject((Object)cloneObserver);
                        CachedOutputStream cachedOutputStream = (CachedOutputStream)message.getContent(CachedOutputStream.class);
                        if (cachedOutputStream != null) {
                            ((HttpServletRequest)pair.key()).setAttribute("Content", (Object)cachedOutputStream.getBytes());
                        }
                        cloneObserver.beforeInvocation((HttpServletRequest)pair.key(), (HttpServletResponse)pair.value(), frame.getTarget(), frame.getMethod(), frame.getArguments());
                    }
                    long start = System.currentTimeMillis();
                    Object result = frame.invoke();
                    long duration = System.currentTimeMillis() - start;
                    this.server.computePerformance(frame.getMethod(), this.methods, duration);
                    if (cloneObserver != null) {
                        cloneObserver.afterInvocation(result);
                    }
                    Object object = result;
                    return object;
                }
                catch (Exception th) {
                    if (cloneObserver != null) {
                        cloneObserver.onException(th);
                    }
                    this.server.recordFailure(frame.getMethod(), this.methods);
                    this.server.getProvision().log(JaxRSServer.getLogger(), LogLevel.DEBUG, th.getMessage(), (Throwable)th);
                    this.server.handleException(message, frame, th);
                }
                finally {
                    messageThreadLocal.remove();
                }
                return null;
            });
        }
        return this.proxy;
    }
}

