/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.serialization.ObjectMapperFactory;
import net.e6tech.elements.common.util.SystemException;

public class JaxResource {
    private static final ObjectMapper mapper = ObjectMapperFactory.newInstance();
    private Class resourceClass;
    private String resourceClassName;
    private String classLoaderResolver;
    private ClassLoader classLoaderDelegate;
    private boolean singleton;
    private String registerBean;
    private String name;
    private String prototypeResolver;
    private boolean bindHeaderObserver = true;

    public JaxResource() {
    }

    public JaxResource(Class resourceClass) {
        this.resourceClass = resourceClass;
    }

    public static JaxResource from(Map<String, Object> map) {
        try {
            String value = mapper.writeValueAsString(map);
            return (JaxResource)mapper.readValue(value, JaxResource.class);
        }
        catch (JsonProcessingException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public JaxResource resourceClass(String resourceClass) {
        this.setResourceClassName(resourceClass);
        return this;
    }

    public JaxResource resourceClass(Class resourceClass) {
        this.setResourceClass(resourceClass);
        return this;
    }

    public JaxResource classLoader(String classLoaderExpression) {
        this.setClassLoaderResolver(classLoaderExpression);
        return this;
    }

    public JaxResource classLoader(ClassLoader classLoaderDelegate) {
        this.setClassLoaderDelegate(classLoaderDelegate);
        return this;
    }

    public JaxResource singleton() {
        this.setSingleton(true);
        return this;
    }

    public JaxResource singleton(boolean singleton) {
        this.setSingleton(singleton);
        return this;
    }

    public JaxResource prototype(String prototype) {
        this.setPrototypeResolver(prototype);
        return this;
    }

    public JaxResource bindHeaderObserver(boolean b) {
        this.setBindHeaderObserver(b);
        return this;
    }

    public JaxResource name(String name) {
        this.setName(name);
        return this;
    }

    public JaxResource bean(String name) {
        this.setRegisterBean(name);
        return this;
    }

    public Class getResourceClass() {
        return this.resourceClass;
    }

    public void setResourceClass(Class resourceClass) {
        this.resourceClass = resourceClass;
    }

    @JsonProperty(value="class")
    public String getResourceClassName() {
        return this.resourceClassName;
    }

    @JsonProperty(value="class")
    public void setResourceClassName(String resourceClassName) {
        this.resourceClassName = resourceClassName;
    }

    @JsonProperty(value="classLoader")
    public String getClassLoaderResolver() {
        return this.classLoaderResolver;
    }

    @JsonProperty(value="classLoader")
    public void setClassLoaderResolver(String classLoaderResolver) {
        this.classLoaderResolver = classLoaderResolver;
    }

    public ClassLoader getClassLoaderDelegate() {
        return this.classLoaderDelegate;
    }

    public void setClassLoaderDelegate(ClassLoader classLoaderDelegate) {
        this.classLoaderDelegate = classLoaderDelegate;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public String getRegisterBean() {
        return this.registerBean;
    }

    public void setRegisterBean(String registerBean) {
        this.registerBean = registerBean;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="prototype")
    public String getPrototypeResolver() {
        return this.prototypeResolver;
    }

    @JsonProperty(value="prototype")
    public void setPrototypeResolver(String prototypeResolver) {
        this.prototypeResolver = prototypeResolver;
    }

    public boolean isBindHeaderObserver() {
        return this.bindHeaderObserver;
    }

    public void setBindHeaderObserver(boolean bindHeaderObserver) {
        this.bindHeaderObserver = bindHeaderObserver;
    }

    public Class resolveResourceClass(ClassLoader externalLoader, Configuration.Resolver resolver) {
        Class<?> cls = this.getResourceClass();
        if (cls != null) {
            return cls;
        }
        if (this.getResourceClassName() == null) {
            throw new SystemException("Missing resource class in resources map");
        }
        try {
            ClassLoader loader = this.getClassLoaderDelegate();
            String classLoaderExpression = this.getClassLoaderResolver();
            if (loader == null && classLoaderExpression != null && resolver != null) {
                loader = (ClassLoader)resolver.resolve(classLoaderExpression);
            }
            if (loader == null) {
                loader = externalLoader == null ? this.getClass().getClassLoader() : externalLoader;
            }
            cls = loader.loadClass(this.getResourceClassName());
            this.setResourceClass(cls);
        }
        catch (ClassNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
        return this.getResourceClass();
    }

    public Object resolvePrototype(ClassLoader externalLoader, Configuration.Resolver resolver) {
        Object prototype = null;
        if (this.prototypeResolver != null && resolver != null) {
            prototype = resolver.resolve(this.prototypeResolver);
        }
        if (prototype == null && this.isSingleton()) {
            if (this.resourceClass == null) {
                this.resolveResourceClass(externalLoader, resolver);
            }
            try {
                prototype = this.resourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        return prototype;
    }
}

