/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf.jetty;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import net.e6tech.elements.security.JavaKeyStore;
import net.e6tech.elements.security.SelfSignedCert;
import net.e6tech.elements.web.cxf.CXFServer;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;

public class JettySSL {
    public void initialize(CXFServer server) throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        KeyManager[] keyManagers;
        String keyStoreFile = server.getKeyStoreFile();
        SelfSignedCert selfSignedCert = server.getSelfSignedCert();
        KeyStore keyStore = server.getKeyStore();
        if (keyStoreFile == null && selfSignedCert == null && keyStore == null) {
            return;
        }
        if (keyStore != null || keyStoreFile != null) {
            JavaKeyStore jceKeyStore = keyStore != null ? new JavaKeyStore(keyStore) : new JavaKeyStore(keyStoreFile, server.getKeyStorePassword(), server.getKeyStoreFormat());
            if (server.getKeyManagerPassword() == null) {
                server.setKeyManagerPassword(server.getKeyStorePassword());
            }
            jceKeyStore.init(server.getKeyManagerPassword());
            keyManagers = jceKeyStore.getKeyManagers();
            trustManagers = jceKeyStore.getTrustManagers();
        } else {
            keyManagers = selfSignedCert.getKeyManagers();
            trustManagers = selfSignedCert.getTrustManagers();
        }
        TLSServerParameters tlsParams = new TLSServerParameters();
        tlsParams.setKeyManagers(keyManagers);
        tlsParams.setTrustManagers(trustManagers);
        ClientAuthentication ca = this.getClientAuthentication(server);
        if (ca.isRequired() == null) {
            ca.setRequired(Boolean.valueOf(false));
        }
        if (ca.isWant() == null) {
            ca.setWant(Boolean.valueOf(false));
        }
        tlsParams.setClientAuthentication(ca);
        JettyHTTPServerEngineFactory factory = new JettyHTTPServerEngineFactory();
        for (URL url : server.getURLs()) {
            TLSServerParameters existingParams;
            if (!"https".equals(url.getProtocol())) continue;
            JettyHTTPServerEngine engine = factory.retrieveJettyHTTPServerEngine(url.getPort());
            TLSServerParameters tLSServerParameters = existingParams = engine == null ? null : engine.getTlsServerParameters();
            if (existingParams != null) {
                LinkedHashSet keyManagerSet = new LinkedHashSet();
                if (existingParams.getKeyManagers() != null) {
                    Collections.addAll(keyManagerSet, existingParams.getKeyManagers());
                }
                if (keyManagers != null) {
                    Collections.addAll(keyManagerSet, keyManagers);
                }
                LinkedHashSet trustManagerSet = new LinkedHashSet();
                if (existingParams.getTrustManagers() != null) {
                    Collections.addAll(trustManagerSet, existingParams.getTrustManagers());
                }
                if (trustManagers != null) {
                    Collections.addAll(trustManagerSet, trustManagers);
                }
                existingParams.setKeyManagers(keyManagerSet.toArray(new KeyManager[0]));
                existingParams.setTrustManagers(trustManagerSet.toArray(new TrustManager[0]));
                ClientAuthentication clientAuthentication = this.getClientAuthentication(server);
                if (clientAuthentication.isRequired() != null || clientAuthentication.isWant() != null) {
                    existingParams.setClientAuthentication(clientAuthentication);
                }
                this.customize(server, existingParams);
                continue;
            }
            factory.setTLSServerParametersForPort(url.getPort(), tlsParams);
            this.customize(server, tlsParams);
        }
    }

    protected ClientAuthentication getClientAuthentication(CXFServer server) {
        ClientAuthentication clientAuthentication = new ClientAuthentication();
        String value = server.getClientAuth();
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "require".equalsIgnoreCase(value) || "required".equalsIgnoreCase(value)) {
            clientAuthentication.setRequired(Boolean.valueOf(true));
        } else if ("optional".equalsIgnoreCase(value) || "want".equalsIgnoreCase(value)) {
            clientAuthentication.setWant(Boolean.valueOf(true));
        } else if (!("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "none".equalsIgnoreCase(value) || value == null)) {
            throw new IllegalArgumentException("Invalid ClientAuth value: " + value);
        }
        return clientAuthentication;
    }

    protected void customize(CXFServer server, TLSServerParameters tlsParams) {
    }
}

