/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.webserver.jetty;

import java.util.Map;
import javax.servlet.Servlet;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.web.webserver.WebEngine;
import net.e6tech.elements.web.webserver.WebServer;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyWebEngine
implements WebEngine {
    private static Logger logger = Logger.getLogger();
    private int maxThreads = 0;
    private int minThreads = 0;

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public Server init(WebServer webServer) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        if (this.maxThreads > 0) {
            threadPool.setMaxThreads(this.maxThreads);
        }
        if (this.minThreads > 0) {
            threadPool.setMinThreads(this.minThreads);
        }
        Server server = webServer.computeServerData(() -> new Server((ThreadPool)threadPool));
        if (webServer.getHttpPort() >= 0) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(webServer.isSendServerVersion());
            ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            http.setHost(webServer.getHost());
            http.setPort(webServer.getHttpPort());
            server.addConnector((Connector)http);
        }
        if (webServer.getHttpsPort() >= 0) {
            if (webServer.getKeyStoreFile() == null) {
                throw logger.systemException("Null keystore");
            }
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStoreType(webServer.getKeyStoreFormat());
            sslContextFactory.setKeyStorePath(webServer.getKeyStoreFile());
            sslContextFactory.setKeyStorePassword(new String(webServer.getKeyStorePassword()));
            sslContextFactory.setKeyManagerPassword(new String(webServer.getKeyManagerPassword()));
            sslContextFactory.setProtocol(webServer.getSslProtocol());
            sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
            HttpConfiguration httpsConfig = new HttpConfiguration();
            httpsConfig.setSecureScheme("https");
            httpsConfig.setSecurePort(webServer.getHttpsPort());
            httpsConfig.setSendDateHeader(false);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            httpsConfig.setSendServerVersion(webServer.isSendServerVersion());
            ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            sslConnector.setPort(webServer.getHttpsPort());
            sslConnector.setHost(webServer.getHost());
            String value = webServer.getClientAuth();
            if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "require".equalsIgnoreCase(value) || "required".equalsIgnoreCase(value)) {
                sslContextFactory.setNeedClientAuth(true);
            } else if ("optional".equalsIgnoreCase(value) || "want".equalsIgnoreCase(value)) {
                sslContextFactory.setWantClientAuth(true);
            } else if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "none".equalsIgnoreCase(value) || value == null) {
                sslContextFactory.setTrustAll(true);
            } else {
                throw new IllegalArgumentException("Invalid ClientAuth value: " + value);
            }
            server.addConnector((Connector)sslConnector);
        }
        return server;
    }

    @Override
    public void start(WebServer webServer) {
        Server server = this.init(webServer);
        HandlerCollection handlers = new HandlerCollection();
        this.initServlets(webServer, server, handlers);
        server.setHandler((Handler)handlers);
        try {
            server.start();
        }
        catch (Exception e) {
            throw logger.systemException((Throwable)e);
        }
    }

    @Override
    public void stop(WebServer webServer) {
        Server server = (Server)webServer.getServerData();
        if (server == null) {
            return;
        }
        try {
            server.stop();
            server.destroy();
            webServer.setServerData(null);
        }
        catch (Exception ex) {
            logger.warn("Cannot stop Jetty {}:{}", (Object)webServer.getHost(), (Object)webServer.getHttpPort());
        }
    }

    protected void initServlets(WebServer webServer, Server server, HandlerCollection handlers) {
        if (webServer.getServlets().size() > 0) {
            ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, webServer.getRootContext());
            for (Map.Entry<String, Servlet> entry : webServer.getServlets().entrySet()) {
                handler.addServlet(new ServletHolder(entry.getValue()), entry.getKey());
            }
            handlers.addHandler((Handler)handler);
        }
    }
}

