/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.management.JMException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.jmx.JMXService;
import net.e6tech.elements.jmx.stat.Measurement;
import net.e6tech.elements.security.SelfSignedCert;
import net.e6tech.elements.web.JaxExceptionHandler;
import net.e6tech.elements.web.cxf.InvocationException;
import net.e6tech.elements.web.cxf.Observer;
import net.e6tech.elements.web.cxf.ServerController;
import net.e6tech.elements.web.cxf.ServerEngine;
import org.apache.cxf.message.Message;

public class CXFServer
implements Initializable,
Startable {
    private static final String CANNOT_BE_NULL = " cannot be null. \n";
    private static final Logger logger = Logger.getLogger();
    private Provision provision;
    private Interceptor interceptor;
    private List<URL> urls = new LinkedList<URL>();
    private String keyStoreFile;
    private String keyStoreFormat = "PKCS12";
    private KeyStore keyStore;
    private char[] keyStorePassword;
    private char[] keyManagerPassword;
    private String sslProtocol = "TLS";
    private String clientAuth;
    private SelfSignedCert selfSignedCert;
    private boolean sendServerVersion = false;
    private boolean initialized = false;
    private boolean started = false;
    private boolean measurement = false;
    private Observer headerObserver;
    private ExceptionMapper exceptionMapper;
    private Map<String, String> responseHeaders = new LinkedHashMap<String, String>();
    private ServerEngine serverEngine;
    private Class<? extends ServerEngine> serverEngineClass;
    private Object serverEngineData;
    private List<ServerController> controllers = new LinkedList<ServerController>();

    public void setAddresses(List<String> addresses) throws MalformedURLException {
        for (String address : addresses) {
            URL url = new URL(address);
            if (this.urls.contains(url)) continue;
            this.urls.add(url);
        }
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Inject
    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public List<URL> getURLs() {
        return this.urls;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public char[] getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    public void setKeyManagerPassword(char[] keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public SelfSignedCert getSelfSignedCert() {
        return this.selfSignedCert;
    }

    public void setSelfSignedCert(SelfSignedCert selfSignedCert) {
        this.selfSignedCert = selfSignedCert;
    }

    public boolean isSendServerVersion() {
        return this.sendServerVersion;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    public boolean isMeasurement() {
        return this.measurement;
    }

    public Observer getHeaderObserver() {
        return this.headerObserver;
    }

    @Inject(optional=true)
    public void setHeaderObserver(Observer headerObserver) {
        this.headerObserver = headerObserver;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }

    public ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    @Inject(optional=true)
    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public ServerEngine getServerEngine() {
        return this.serverEngine;
    }

    @Inject(optional=true)
    public void setServerEngine(ServerEngine serverEngine) {
        this.serverEngine = serverEngine;
    }

    public Class<? extends ServerEngine> getServerEngineClass() {
        return this.serverEngineClass;
    }

    public void setServerEngineClass(Class<? extends ServerEngine> serverEngineClass) {
        this.serverEngineClass = serverEngineClass;
    }

    public <T> T getServerEngineData() {
        return (T)this.serverEngineData;
    }

    public <T> void setServerEngineData(T serverEngineData) {
        this.serverEngineData = serverEngineData;
    }

    public <T> T computeServerEngineData(Supplier<T> supplier) {
        if (this.serverEngineData == null) {
            this.setServerEngineData(supplier.get());
        }
        return (T)this.serverEngineData;
    }

    protected void addController(ServerController controller) {
        if (!this.controllers.contains(controller)) {
            this.controllers.add(controller);
        }
    }

    public void initialize(Resources resources) {
        this.initialized = true;
        if (resources != null) {
            resources.getResourceManager().onShutdown("CXFServer " + this.getURLs(), notification -> this.stop());
        }
        if (this.serverEngine == null) {
            try {
                Class<? extends ServerEngine> cls = this.serverEngineClass != null ? this.serverEngineClass : this.getClass().getClassLoader().loadClass("net.e6tech.elements.web.cxf.jetty.JettyEngine");
                this.serverEngine = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new SystemException((Throwable)ex);
            }
        }
        if (resources != null) {
            resources.inject((Object)this.serverEngine);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        if (!this.initialized) {
            this.initialize(null);
        }
        if (this.started) {
            return;
        }
        this.started = true;
        for (ServerController controller : this.controllers) {
            this.serverEngine.start(this, controller);
        }
    }

    public void stop() {
        this.serverEngine.stop(this);
        this.started = false;
    }

    Pair<HttpServletRequest, HttpServletResponse> getServletRequestResponse(Message message) {
        Pair pair = new Pair(null, null);
        if (message != null) {
            HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            HttpServletResponse response = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            pair = new Pair((Object)request, (Object)response);
            if (response != null) {
                this.getResponseHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            }
        }
        return pair;
    }

    void handleException(Message message, CallFrame frame, Throwable th) throws Throwable {
        Throwable throwable = ExceptionMapper.unwrap((Throwable)th);
        if (frame.getTarget() instanceof JaxExceptionHandler) {
            Object response = ((JaxExceptionHandler)frame.getTarget()).handleException(frame, throwable);
            if (response != null) {
                InvocationException exception = new InvocationException(response);
                this.serverEngine.onException(message, frame, exception);
                throw exception;
            }
        } else {
            this.serverEngine.onException(message, frame, throwable);
            throw throwable;
        }
    }

    void computePerformance(Method method, Map<Method, String> methods, long duration) {
        ObjectInstance instance = null;
        try {
            instance = this.getMeasurement(method, methods);
            logger.trace("{} call took {}ms", (Object)instance.getObjectName().getCanonicalName(), (Object)duration);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"add", (Object[])new Object[]{duration});
        }
        catch (Exception e) {
            logger.debug("Unable to record measurement for " + method, (Throwable)e);
        }
    }

    void recordFailure(Method method, Map<Method, String> methods) {
        try {
            ObjectInstance instance = this.getMeasurement(method, methods);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"fail", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Unable to record fail measurement for " + method, (Throwable)e);
        }
    }

    private ObjectInstance getMeasurement(Method method, Map<Method, String> methods) throws JMException {
        String methodName = methods.computeIfAbsent(method, m -> {
            StringBuilder builder = new StringBuilder();
            builder.append(m.getDeclaringClass().getTypeName());
            builder.append(".");
            builder.append(m.getName());
            Class<?>[] types = m.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                builder.append("|");
                builder.append(types[i].getSimpleName());
            }
            return builder.toString();
        });
        String objectName = "net.e6tech:type=Restful,name=" + methodName;
        return JMXService.registerIfAbsent((String)objectName, () -> new Measurement(methodName, "ms", this.isMeasurement()));
    }

    void checkInvocation(Method method, Object[] args) {
        Parameter[] params = method.getParameters();
        int idx = 0;
        StringBuilder builder = null;
        for (Parameter param : params) {
            QueryParam queryParam = param.getAnnotation(QueryParam.class);
            PathParam pathParam = param.getAnnotation(PathParam.class);
            if (args[idx] == null || args[idx] instanceof String && ((String)args[idx]).trim().isEmpty()) {
                if (pathParam != null) {
                    if (builder == null) {
                        builder = new StringBuilder();
                    }
                    builder.append("path parameter ").append(pathParam.value()).append(CANNOT_BE_NULL);
                }
                if (param.getAnnotation(Nonnull.class) != null) {
                    if (queryParam != null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("query parameter ").append(queryParam.value()).append(CANNOT_BE_NULL);
                    } else if (pathParam == null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("post parameter ").append("arg").append(idx).append(CANNOT_BE_NULL);
                    }
                }
            }
            ++idx;
        }
        if (builder != null) {
            throw new IllegalArgumentException(builder.toString());
        }
    }
}

