/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class Member {
    private String memberId;
    private String name;
    private String hostAddress;
    private long expiration;
    private String toString;

    public static String formatISODateTime(long timeMillis, ZoneId zoneId) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), zoneId));
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String address) {
        this.hostAddress = address.trim();
        while (this.hostAddress.endsWith("/")) {
            this.hostAddress = this.hostAddress.substring(0, this.hostAddress.length() - 1);
        }
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
        this.toString = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return this.memberId.equals(member.memberId) && this.hostAddress.equals(member.hostAddress);
    }

    public int hashCode() {
        return Objects.hash(this.memberId, this.hostAddress);
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "memberId=" + this.memberId + ",hostAddress='" + this.hostAddress + "',expiration=" + Member.formatISODateTime(this.expiration, ZoneId.systemDefault());
        }
        return this.toString;
    }
}

