/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorListener;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.restful.RestfulProxy;
import net.e6tech.elements.security.SymmetricCipher;
import net.e6tech.elements.web.federation.AuthObserver;
import net.e6tech.elements.web.federation.BeaconAPI;
import net.e6tech.elements.web.federation.Member;

public class HailingFrequency {
    protected static SymmetricCipher cipher = SymmetricCipher.getInstance((String)"AES");
    private Member member;
    private Map<Class, Object> services = new ConcurrentHashMap<Class, Object>();
    private RestfulProxy proxy;
    private AuthObserver observer;
    private MyInterceptorListener listener = new MyInterceptorListener();
    private int connectionTimeout = 15000;
    private int readTimeout = 10000;

    public HailingFrequency() {
    }

    public HailingFrequency(Member member, AuthObserver observer) {
        this.setMember(member);
        this.observer = observer;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public HailingFrequency connectionTimeout(int connectionTimeout) {
        this.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public HailingFrequency readTimeout(int readTimeout) {
        this.setReadTimeout(readTimeout);
        return this;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
        if (this.proxy == null || !this.proxy.getClient().getAddress().equals(member.getHostAddress())) {
            this.proxy = new RestfulProxy(member.getHostAddress());
            this.services.put(BeaconAPI.class, this.proxy.newProxy(BeaconAPI.class, (InterceptorListener)this.listener));
            this.proxy.getClient().setReadTimeout(this.readTimeout);
            this.proxy.getClient().setConnectionTimeout(this.connectionTimeout);
        }
    }

    public BeaconAPI beacon() {
        return this.getService(BeaconAPI.class);
    }

    public <T> T getService(Class<T> cls) {
        return (T)this.services.computeIfAbsent(cls, serviceClass -> this.proxy.newProxy(cls, (InterceptorListener)this.listener));
    }

    public <T> T removeService(Class<T> cls) {
        return (T)this.services.remove(cls);
    }

    public String memberId() {
        return this.member.getMemberId();
    }

    private class MyInterceptorListener
    implements InterceptorListener {
        private MyInterceptorListener() {
        }

        public void preInvocation(CallFrame frame) {
            if (HailingFrequency.this.observer == null) {
                return;
            }
            HailingFrequency.this.observer.authorize(HailingFrequency.this.proxy);
        }

        public Object onException(CallFrame frame, Throwable throwable) {
            throw new SystemException(throwable);
        }
    }
}

