/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.web.federation.Event;
import net.e6tech.elements.web.federation.Federation;
import net.e6tech.elements.web.federation.HailingFrequency;
import net.e6tech.elements.web.federation.Member;

public class Beacon {
    public static Logger logger = Logger.getLogger();
    private Federation federation;
    private Cache<UUID, Event> events;
    private final Random random = new Random();
    private volatile boolean shutdown = false;
    private ReentrantLock seeding = new ReentrantLock();
    private List<HailingFrequency> seedFrequencies = Collections.unmodifiableList(new ArrayList());
    private Thread eventThread;
    private Map<String, HailingFrequency> frequencies = new ConcurrentHashMap<String, HailingFrequency>(128);

    public Federation getFederation() {
        return this.federation;
    }

    public void setFederation(Federation federation) {
        this.federation = federation;
    }

    protected void seeds(List<Member> seeds) {
        List list = seeds.stream().map(s -> new HailingFrequency((Member)s, this.federation.getAuthObserver()).connectionTimeout(this.federation.getConnectionTimeout()).readTimeout(this.federation.getReadTimeout())).collect(Collectors.toList());
        this.seedFrequencies = Collections.unmodifiableList(list);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public Collection<Member> members() {
        return this.frequencies.values().stream().map(HailingFrequency::getMember).collect(Collectors.toList());
    }

    protected int knownFrequencies() {
        return this.frequencies.size();
    }

    protected void trimFrequencies() {
        this.frequencies.values().removeIf(f -> !this.federation.getHostedMembers().containsKey(f.memberId()) && f.getMember().getExpiration() < System.currentTimeMillis());
    }

    public HailingFrequency getFrequency(String memberId) {
        return this.frequencies.get(memberId);
    }

    protected HailingFrequency updateFrequency(Member member) {
        HailingFrequency f = this.frequencies.get(member.getMemberId());
        if (f == null) {
            f = new HailingFrequency(member, this.federation.getAuthObserver());
            f.connectionTimeout(this.federation.getConnectionTimeout()).readTimeout(this.federation.getReadTimeout());
            this.frequencies.put(member.getMemberId(), f);
            if (f.getMember().getExpiration() < member.getExpiration()) {
                f.setMember(member);
            }
            HailingFrequency f2 = f;
            CompletableFuture.runAsync(() -> this.federation.getListeners().forEach(listener -> listener.added(f2)));
        } else if (f.getMember().getExpiration() < member.getExpiration()) {
            f.setMember(member);
        }
        return f;
    }

    protected void updateFrequencies(Collection<Member> list) {
        for (Member member : list) {
            this.updateFrequency(member);
        }
    }

    protected void removeFrequency(HailingFrequency frequency) {
        if (frequency != null && !this.federation.getHostedMembers().containsKey(frequency.getMember().getMemberId())) {
            HailingFrequency c = this.frequencies.remove(frequency.memberId());
            CompletableFuture.runAsync(() -> this.federation.getListeners().forEach(listener -> listener.removed(c)));
        }
    }

    protected void removeFrequencies(Collection<Member> list) {
        for (Member member : list) {
            if (this.federation.getHostedMembers().containsKey(member.getMemberId())) continue;
            HailingFrequency c = this.frequencies.remove(member.getMemberId());
            CompletableFuture.runAsync(() -> this.federation.getListeners().forEach(listener -> listener.removed(c)));
        }
    }

    protected Map<String, HailingFrequency> frequencies() {
        return this.frequencies;
    }

    public void start() {
        if (this.events != null) {
            this.events.invalidateAll();
            this.events.cleanUp();
        }
        this.events = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).initialCapacity(this.federation.getEventCacheInitialCapacity()).expireAfterAccess(this.federation.getEventCacheExpire(), TimeUnit.MILLISECONDS).build();
        this.shutdown = false;
        Thread thread = new Thread(this::run);
        thread.start();
    }

    private void run() {
        this.federation.getHostedMembers().values().forEach(m -> {
            this.federation.refresh((Member)m);
            this.updateFrequency((Member)m);
        });
        while (this.frequencies.size() == 0) {
            HailingFrequency frequency = this.frequencies.values().iterator().next();
            try {
                frequency.beacon().members();
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {}
            }
        }
        logger.trace("{} start seeding.", (Object)this.federation.getHostAddress());
        this.seeds("start");
        logger.trace("{} done seeding.", (Object)this.federation.getHostAddress());
        this.eventThread = new Thread(this::events);
        this.eventThread.start();
        Thread sync = new Thread(this::sync);
        sync.start();
        try {
            Thread.sleep(this.federation.getRenewalInterval());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Thread renewal = new Thread(this::renewal);
        renewal.start();
    }

    private void seeds(String from) {
        if (!this.seeding.tryLock()) {
            return;
        }
        try {
            while (true) {
                if (this.syncMembers(this.seedFrequencies)) {
                    logger.trace("{} {} seeds announce ", (Object)this.federation.getHostAddress(), (Object)from);
                    this.announce();
                    break;
                }
                try {
                    Thread.sleep(this.federation.getSeedRefreshInterval());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.seeding.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event) {
        if (this.shutdown) {
            return;
        }
        Cache<UUID, Event> cache = this.events;
        synchronized (cache) {
            Event existing = (Event)this.events.getIfPresent((Object)event.getUuid());
            if (existing != null && existing != null && existing.getUuid().equals(event.getUuid())) {
                event.getVisited().addAll(existing.getVisited());
                if (event.getCycle() > existing.getCycle()) {
                    event.setCycle(existing.getCycle());
                }
                this.events.put((Object)event.getUuid(), (Object)event);
                return;
            }
        }
        logger.trace("{} onEvent: {}", (Object)this.federation.getHostAddress(), (Object)event);
        if (event.getType() == Event.Type.ANNOUNCE) {
            this.updateFrequencies(event.getMembers());
        } else if (event.getType() == Event.Type.REMOVE) {
            this.removeFrequencies(event.getMembers());
        }
        if (event.getCycle() > 0) {
            cache = this.events;
            synchronized (cache) {
                this.events.put((Object)event.getUuid(), (Object)event);
                this.federation.getHostedMembers().values().forEach(m -> event.getVisited().add(m.getMemberId()));
                event.getVisited().addAll(this.federation.getHostedMembers().keySet());
                this.events.notifyAll();
            }
        }
    }

    private void decrementCycle(Event event) {
        if (event.getCycle() > 0) {
            event.setCycle(event.getCycle() - 1);
        }
    }

    private void announce() {
        this.trimFrequencies();
        this.federation.getHostedMembers().values().forEach(this.federation::refresh);
        ArrayList<Member> list = new ArrayList<Member>(this.federation.getHostedMembers().size());
        list.addAll(this.federation.getHostedMembers().values());
        Event event = new Event(Event.Type.ANNOUNCE, list, this.federation.getCycle());
        event.getVisited().addAll(this.federation.getHostedMembers().keySet());
        this.gossip(event);
    }

    void announce(Member member) {
        this.federation.refresh(member);
        ArrayList<Member> list = new ArrayList<Member>();
        list.add(member);
        this.onEvent(new Event(Event.Type.ANNOUNCE, list, this.federation.getCycle()));
    }

    private void renewal() {
        while (!this.shutdown) {
            try {
                long interval = this.federation.getRenewalInterval() + (long)this.federation.getCycle() * this.federation.getEventInterval();
                if (this.knownFrequencies() <= this.federation.getHostedMembers().size()) {
                    this.seeds("renewal");
                    Thread.sleep(interval);
                    continue;
                }
                long now = System.currentTimeMillis();
                logger.trace("{} renewal: ", (Object)this.federation.getHostAddress());
                this.announce();
                long sleep = interval - (System.currentTimeMillis() - now);
                if (sleep < 0L) {
                    sleep = this.federation.getRenewalInterval();
                }
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception ex) {
                logger.error("renewal", (Throwable)ex);
            }
        }
    }

    private void events() {
        while (!this.shutdown) {
            try {
                this.processEvents();
                Thread.sleep(this.federation.getEventInterval());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception ex) {
                logger.error("events", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        int after;
        int before;
        LinkedList copy = new LinkedList();
        Cache<UUID, Event> cache = this.events;
        synchronized (cache) {
            while (this.events.size() == 0L || this.knownFrequencies() <= this.federation.getHostedMembers().size()) {
                try {
                    this.events.wait();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            ConcurrentMap map = this.events.asMap();
            copy.addAll(map.values());
            copy.forEach(this::decrementCycle);
            before = copy.size();
            map.entrySet().removeIf(e -> ((Event)e.getValue()).getCycle() <= 0);
            after = copy.size();
        }
        logger.trace("{} event size {}, {}", new Object[]{this.federation.getHostAddress(), before, after});
        copy.forEach(this::gossip);
    }

    private void sync() {
        while (!this.shutdown) {
            try {
                if (this.knownFrequencies() >= this.federation.getHostedMembers().size()) {
                    this.syncMembers(this.frequencies().values());
                }
                Thread.sleep(this.federation.getSyncInterval());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception ex) {
                logger.error("sync", (Throwable)ex);
            }
        }
    }

    private boolean syncMembers(Collection<HailingFrequency> fList) {
        if (fList.isEmpty()) {
            return false;
        }
        List list = fList.stream().filter(c -> !this.federation.getHostedMembers().containsKey(c.memberId())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return true;
        }
        while (true) {
            HailingFrequency frequency = null;
            try {
                if (list.isEmpty()) {
                    return false;
                }
                int n = this.random.nextInt(list.size());
                frequency = (HailingFrequency)list.remove(n);
                Collection<Member> list2 = frequency.beacon().members();
                logger.trace("{} syncMembers: {}", (Object)this.federation.getHostAddress(), list2);
                this.updateFrequencies(list2);
                return true;
            }
            catch (Exception ex) {
                this.removeFrequency(frequency);
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        long now = System.currentTimeMillis();
        this.federation.getHostedMembers().values().forEach(m -> m.setExpiration(now));
        ArrayList<Member> list = new ArrayList<Member>(this.federation.getHostedMembers().size());
        list.addAll(this.federation.getHostedMembers().values());
        Event event = new Event(Event.Type.REMOVE, list, this.federation.getCycle());
        event.getVisited().addAll(this.federation.getHostedMembers().keySet());
        for (Member member : list) {
            HailingFrequency c = this.frequencies.remove(member.getMemberId());
            CompletableFuture.runAsync(() -> this.federation.getListeners().forEach(listener -> listener.removed(c)));
        }
        this.gossip(event);
        if (this.eventThread != null) {
            this.eventThread.interrupt();
            this.eventThread = null;
        }
        if (this.events != null) {
            this.events.invalidateAll();
        }
    }

    private boolean gossip(Event event) {
        List<HailingFrequency> chosen;
        List<HailingFrequency> list = this.frequencies.values().stream().filter(c -> !event.getVisited().contains(c.memberId())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return false;
        }
        int fanout = this.federation.getFanout();
        if (fanout >= list.size()) {
            chosen = list;
        } else {
            chosen = new ArrayList(fanout);
            for (int i = 0; i < fanout; ++i) {
                int n = this.random.nextInt(list.size());
                chosen.add((HailingFrequency)list.get(n));
                list.remove(n);
            }
        }
        AtomicBoolean atomic = new AtomicBoolean(false);
        chosen.forEach(frequency -> {
            logger.trace("{} gossip to {}: {}", new Object[]{this.federation.getHostAddress(), frequency.memberId(), event});
            try {
                frequency.beacon().onEvent(event);
                atomic.set(true);
            }
            catch (Exception ex) {
                this.removeFrequency((HailingFrequency)frequency);
            }
        });
        return atomic.get();
    }
}

