/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.webserver;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.webserver.WebEngine;

public class WebServer
implements Startable {
    protected static Logger logger = Logger.getLogger();
    private int httpPort = 0;
    private int httpsPort = 0;
    private String keyStoreFile;
    private String keyStoreFormat = "JKS";
    private char[] keyStorePassword;
    private char[] keyManagerPassword;
    private String sslProtocol = "TLS";
    private String rootContext = "/";
    private Map<String, Servlet> servlets = new LinkedHashMap<String, Servlet>();
    private Map<String, String> servletClasses = new LinkedHashMap<String, String>();
    private ClassLoader classLoader;
    private WebEngine engine;
    private Class<WebEngine> engineClass;
    private Object serverData;
    private String host = "0.0.0.0";
    private String clientAuth;
    private boolean sendServerVersion = false;
    private Provision provision;
    private boolean started = false;

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        WebServer.logger = logger;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public char[] getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    public void setKeyManagerPassword(char[] keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(String rootContext) {
        this.rootContext = rootContext;
    }

    public Map<String, Servlet> getServlets() {
        return this.servlets;
    }

    public void setServlets(Map<String, Servlet> servlets) {
        this.servlets = servlets;
    }

    public Map<String, String> getServletClasses() {
        return this.servletClasses;
    }

    public void setServletClasses(Map<String, String> servletClasses) {
        this.servletClasses = servletClasses;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    @Inject(optional=true)
    public void setEngine(WebEngine engine) {
        this.engine = engine;
    }

    public Class<WebEngine> getEngineClass() {
        return this.engineClass;
    }

    public void setEngineClass(Class<WebEngine> engineClass) {
        this.engineClass = engineClass;
    }

    public void addServlet(String context, Servlet servlet) {
        this.servlets.put(context, servlet);
    }

    public <T> T getServerData() {
        return (T)this.serverData;
    }

    public void setServerData(Object serverData) {
        this.serverData = serverData;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isSendServerVersion() {
        return this.sendServerVersion;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public <T> T computeServerData(Supplier<T> supplier) {
        if (this.serverData == null) {
            this.setServerData(supplier.get());
        }
        return (T)this.serverData;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.getProvision().getResourceManager().onShutdown("WebServer " + this.getHost(), notification -> this.stop());
        for (Map.Entry<String, String> entry : this.getServletClasses().entrySet()) {
            try {
                ClassLoader loader = this.classLoader != null ? this.classLoader : this.getProvision().getClass().getClassLoader();
                Class<?> servletClass = loader.loadClass(entry.getValue());
                Servlet servlet = (Servlet)servletClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.addServlet(entry.getKey(), servlet);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        if (this.engine == null) {
            try {
                Class<WebEngine> cls = this.engineClass != null ? this.engineClass : this.getClass().getClassLoader().loadClass("net.e6tech.elements.web.webserver.jetty.JettyWebEngine");
                this.engine = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new SystemException((Throwable)ex);
            }
        }
        this.engine.start(this);
    }

    public void stop() {
        this.engine.stop(this);
        this.started = false;
    }
}

