/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotAuthorizedException;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.restful.RestfulProxy;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.SymmetricCipher;
import net.e6tech.elements.web.cxf.Observer;

public class AuthObserver
extends Observer {
    protected static SymmetricCipher cipher = SymmetricCipher.getInstance((String)"AES");
    private String sharedKey;
    private SecretKey secretKey;
    private long expiration = 60000L;

    public String getSharedKey() {
        return this.sharedKey;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        if (sharedKey != null) {
            this.secretKey = cipher.getKeySpec(Hex.toBytes((String)sharedKey));
        }
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public void authorize(RestfulProxy proxy) {
        String token;
        try {
            token = this.encrypt();
        }
        catch (GeneralSecurityException e) {
            throw new SystemException((Throwable)e);
        }
        if (token == null) {
            return;
        }
        proxy.setRequestProperty("Authorization", "SharedKey " + token);
    }

    private String encrypt() throws GeneralSecurityException {
        if (this.secretKey == null) {
            return null;
        }
        byte[] time = Long.toString(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8);
        String encrypted = cipher.encrypt(this.secretKey, time, null);
        return encrypted;
    }

    private long decrypt(String encrypted) throws GeneralSecurityException {
        if (this.secretKey == null) {
            return System.currentTimeMillis();
        }
        byte[] decrypted = cipher.decrypt(this.secretKey, encrypted, null);
        return Long.parseLong(new String(decrypted, StandardCharsets.UTF_8));
    }

    @Override
    public void beforeInvocation(HttpServletRequest request, HttpServletResponse response, Object instance, Method method, Object[] args) {
        block6: {
            String auth = request.getHeader("Authorization");
            if (this.sharedKey != null) {
                if (auth == null) {
                    throw new NotAuthorizedException((Object)"Missing Authorization header", new Object[0]);
                }
                if (auth.startsWith("SharedKey")) {
                    auth = auth.substring("SharedKey".length());
                    auth = auth.trim();
                    try {
                        long time = this.decrypt(auth);
                        if (System.currentTimeMillis() - time > this.expiration) {
                            throw new NotAuthorizedException((Object)"Shared token expired", new Object[0]);
                        }
                        break block6;
                    }
                    catch (GeneralSecurityException e) {
                        throw new SystemException((Throwable)e);
                    }
                }
                throw new NotAuthorizedException((Object)"Missing SharedKey", new Object[0]);
            }
        }
    }
}

