/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf.jetty;

import net.e6tech.elements.common.actor.concurrent.ActorExecutor;
import net.e6tech.elements.common.actor.typed.worker.WorkEvents;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyActorExecutor
extends ContainerLifeCycle
implements ThreadPool {
    private ActorExecutor executor;
    private Provision provision;
    private WorkerPoolConfig workerPoolConfig = new WorkerPoolConfig();

    public JettyActorExecutor() {
        String name = "jat" + ((Object)((Object)this)).hashCode();
        this.workerPoolConfig.setName(name);
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public WorkerPoolConfig getWorkerPoolConfig() {
        return this.workerPoolConfig;
    }

    public void setWorkerPoolConfig(WorkerPoolConfig workerPoolConfig) {
        this.workerPoolConfig = workerPoolConfig;
    }

    protected void doStart() throws Exception {
        if (this.getWorkerPoolConfig().getName() == null) {
            this.workerPoolConfig.setName("jat" + ((Object)((Object)this)).hashCode());
        }
        this.executor = new ActorExecutor(this.provision, this.getWorkerPoolConfig());
        this.executor.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.executor != null) {
            this.executor.stop();
        }
    }

    public void join() {
        if (this.executor != null) {
            this.executor.join();
        }
    }

    public int getThreads() {
        WorkEvents.StatusResponse response = this.executor.status();
        return response.getWorkerCount();
    }

    public int getIdleThreads() {
        WorkEvents.StatusResponse response = this.executor.status();
        return response.getIdleCount();
    }

    public boolean isLowOnThreads() {
        return false;
    }

    public void execute(Runnable command) {
        if (this.executor != null) {
            this.executor.execute(command);
        } else {
            command.run();
        }
    }
}

