/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.ResourcesFactory;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.RestfulClient;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.InstanceResourceProvider;
import net.e6tech.elements.web.cxf.InvocationException;
import net.e6tech.elements.web.cxf.JaxRSServerController;
import net.e6tech.elements.web.cxf.JaxResource;
import net.e6tech.elements.web.cxf.Observer;
import net.e6tech.elements.web.cxf.SecurityAnnotationEngine;
import net.e6tech.elements.web.cxf.ServerController;
import net.e6tech.elements.web.cxf.SharedResourceProvider;
import net.e6tech.elements.web.cxf.StatusException;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.LogMessageFormatter;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharingFilter;

public class JaxRSServer
extends CXFServer {
    private static final Logger messageLogger;
    private static final Map<Integer, JaxRSServerController> entries;
    private static Logger logger;
    private List<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
    private List<JaxResource> jaxResources = new ArrayList<JaxResource>();
    private Map<String, Object> instances = new ConcurrentHashMap<String, Object>();
    private boolean corsFilter = false;
    private SecurityAnnotationEngine securityAnnotationEngine;
    private Configuration.Resolver resolver;
    private ClassLoader classLoader;
    private LogEventSender logEventSender;
    private ResourcesFactory resourcesFactory;
    private Consumer<JAXRSServerFactoryBean> customizer;

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        JaxRSServer.logger = logger;
    }

    public List<Map<String, Object>> getResources() {
        return this.resources;
    }

    public void setResources(List<Map<String, Object>> resources) {
        this.resources = resources;
    }

    public List<JaxResource> getJaxResources() {
        return this.jaxResources;
    }

    public void setJaxResources(List<JaxResource> jaxResources) {
        this.jaxResources = jaxResources;
    }

    public JaxRSServer add(JaxResource resource) {
        this.jaxResources.add(resource);
        return this;
    }

    public Map<String, Object> getInstances() {
        return this.instances;
    }

    public Object getInstance(String name) {
        return this.instances.get(name);
    }

    public boolean isCorsFilter() {
        return this.corsFilter;
    }

    public void setCorsFilter(boolean corsFilter) {
        this.corsFilter = corsFilter;
    }

    public SecurityAnnotationEngine getSecurityAnnotationEngine() {
        return this.securityAnnotationEngine;
    }

    @Inject(optional=true)
    public void setSecurityAnnotationEngine(SecurityAnnotationEngine securityAnnotationEngine) {
        this.securityAnnotationEngine = securityAnnotationEngine;
    }

    @Inject(optional=true)
    public Configuration.Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Configuration.Resolver resolver) {
        this.resolver = resolver;
    }

    public LogEventSender getLogEventSender() {
        return this.logEventSender;
    }

    public void setLogEventSender(LogEventSender logEventSender) {
        this.logEventSender = logEventSender;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ResourcesFactory getResourcesFactory() {
        return this.resourcesFactory;
    }

    @Inject(optional=true)
    public void setResourcesFactory(ResourcesFactory resourcesFactory) {
        this.resourcesFactory = resourcesFactory;
    }

    public Consumer<JAXRSServerFactoryBean> getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(Consumer<JAXRSServerFactoryBean> customizer) {
        this.customizer = customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JaxRSServerController> updateServerControllers() throws URISyntaxException {
        ArrayList<JaxRSServerController> entryList = new ArrayList<JaxRSServerController>();
        Map<Integer, JaxRSServerController> map = entries;
        synchronized (map) {
            for (URL url : this.getURLs()) {
                JaxRSServerController controller = entries.get(url.getPort());
                if (controller == null) {
                    controller = new JaxRSServerController(url, new JAXRSServerFactoryBean());
                    entries.put(url.getPort(), controller);
                }
                if (!controller.getURI().equals(url.toURI())) {
                    throw new SystemException("Cannot register " + url.toExternalForm() + ".  Already a service at " + url.toExternalForm());
                }
                JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)controller.getFactory();
                bean.setAddress(url.toExternalForm());
                entries.put(url.getPort(), controller);
                entryList.add(controller);
            }
        }
        return entryList;
    }

    private Observer initBindHeaderObserver(Resources res, JaxResource jaxResource) {
        Observer hObserver = this.getHeaderObserver();
        boolean bindHeaderObserver = jaxResource.isBindHeaderObserver();
        if (!bindHeaderObserver) {
            hObserver = null;
        }
        this.injectInitialize(res, hObserver);
        return hObserver;
    }

    private ResourceProvider initResourceProvider(Resources res, JaxResource jaxResource, Observer hObserver) {
        Object resourceProvider;
        Object prototype = jaxResource.resolvePrototype(this.classLoader, this.resolver);
        if (jaxResource.isSingleton()) {
            this.injectInitialize(res, prototype);
            resourceProvider = new SharedResourceProvider(this, prototype, hObserver);
            String beanName = jaxResource.getRegisterBean();
            if (beanName != null) {
                this.getProvision().getResourceManager().registerBean(beanName, prototype);
            }
        } else {
            Module module = res == null ? null : res.getModule();
            ResourcesFactory factory = this.resourcesFactory != null ? this.resourcesFactory : this.getProvision().resourcesFactory();
            resourceProvider = new InstanceResourceProvider(this, jaxResource.getResourceClass(), prototype, module, factory, hObserver);
        }
        String resourceName = jaxResource.getName();
        if (resourceName != null && prototype != null) {
            this.instances.put(resourceName, prototype);
        }
        return resourceProvider;
    }

    @Override
    public void initialize(Resources res) {
        if (this.getURLs().isEmpty()) {
            throw new IllegalStateException("address not set");
        }
        List<JaxRSServerController> entryList = null;
        try {
            entryList = this.updateServerControllers();
        }
        catch (URISyntaxException e) {
            throw new SystemException((Throwable)e);
        }
        this.resources.forEach(m -> this.add(JaxResource.from(m)));
        ArrayList resourceClasses = new ArrayList();
        for (JaxResource jaxResource : this.jaxResources) {
            Class resourceClass = jaxResource.resolveResourceClass(this.classLoader, this.resolver);
            Observer hObserver = this.initBindHeaderObserver(res, jaxResource);
            if (this.securityAnnotationEngine != null) {
                this.securityAnnotationEngine.register(jaxResource.getResourceClass());
            }
            ResourceProvider resourceProvider = this.initResourceProvider(res, jaxResource, hObserver);
            for (JaxRSServerController entry : entryList) {
                ((JAXRSServerFactoryBean)entry.getFactory()).setResourceProvider(resourceClass, resourceProvider);
            }
            resourceClasses.add(resourceClass);
        }
        if (this.securityAnnotationEngine != null) {
            this.securityAnnotationEngine.logMethodMap();
        }
        for (JaxRSServerController controller : entryList) {
            controller.addResourceClasses(resourceClasses);
        }
        super.initialize(res);
    }

    private void injectInitialize(Resources res, Object object) {
        if (res != null) {
            if (object != null) {
                res.inject(object);
            }
        } else if (object != null) {
            this.getProvision().inject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        LinkedList<JAXRSServerFactoryBean> beans = new LinkedList<JAXRSServerFactoryBean>();
        LinkedList<JaxRSServerController> controllers = new LinkedList<JaxRSServerController>();
        Iterator<Object> iterator = entries;
        synchronized (iterator) {
            for (URL url : this.getURLs()) {
                JaxRSServerController controller = entries.get(url.getPort());
                if (controller == null) continue;
                beans.add((JAXRSServerFactoryBean)controller.getFactory());
                ((JAXRSServerFactoryBean)controller.getFactory()).setResourceClasses(controller.getResourceClasses());
                entries.remove(url.getPort());
                controllers.add(controller);
            }
        }
        this.setupJsonProvider(beans);
        this.setupCorsFilter(beans);
        this.setupLogging(beans);
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.setProvider((Object)new InternalExceptionMapper(this.getExceptionMapper()));
        }
        if (this.customizer != null) {
            for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
                this.customizer.accept(jAXRSServerFactoryBean);
            }
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            logger.info("Starting Restful at address {} {} ", (Object)jAXRSServerFactoryBean.getAddress(), (Object)jAXRSServerFactoryBean.getResourceClasses());
        }
        for (ServerController serverController : controllers) {
            this.addController(serverController);
        }
        super.start();
        for (URL uRL : this.getURLs()) {
            try {
                this.kickStart(uRL);
            }
            catch (Exception exception) {}
        }
    }

    private void setupJsonProvider(List<JAXRSServerFactoryBean> beans) {
        for (JAXRSServerFactoryBean bean : beans) {
            bean.getBus().setProperty("skip.default.json.provider.registration", (Object)true);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.WRAP_ROOT_VALUE).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JacksonJaxbJsonProvider jackson = new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        for (JAXRSServerFactoryBean bean : beans) {
            bean.setProvider((Object)jackson);
        }
    }

    private void setupCorsFilter(List<JAXRSServerFactoryBean> beans) {
        if (this.isCorsFilter()) {
            logger.info("enabling CORS filter");
            CrossOriginResourceSharingFilter cf = new CrossOriginResourceSharingFilter();
            for (JAXRSServerFactoryBean bean : beans) {
                bean.setProvider((Object)cf);
            }
        }
    }

    private void setupLogging(List<JAXRSServerFactoryBean> beans) {
        LoggingFeature feature = new LoggingFeature();
        DefaultLogEventSender sender = new DefaultLogEventSender();
        feature.setInSender((LogEventSender)sender);
        feature.setOutSender((LogEventSender)sender);
        for (JAXRSServerFactoryBean bean : beans) {
            bean.getFeatures().add(feature);
        }
    }

    private void kickStart(URL url) throws SocketException {
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface netint : Collections.list(nets)) {
            Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
            for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                if (inetAddress instanceof Inet6Address) continue;
                try {
                    new RestfulClient(url.getProtocol() + "://" + inetAddress.getHostAddress() + ":" + url.getPort() + url.getPath()).get("", new Param[0]);
                }
                catch (Exception exception) {}
            }
        }
        try {
            new RestfulClient(url.getProtocol() + "://localhost:" + url.getPort() + url.getPath()).get("", new Param[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        System.setProperty("org.apache.cxf.useSpringClassHelpers", "false");
        messageLogger = Logger.getLogger((String)(JaxRSServer.class.getName() + ".message"));
        entries = new ConcurrentHashMap<Integer, JaxRSServerController>();
        logger = Logger.getLogger();
    }

    @Provider
    private static class InternalExceptionMapper
    implements ExceptionMapper<Exception> {
        net.e6tech.elements.common.util.ExceptionMapper<?> mapper;

        InternalExceptionMapper(net.e6tech.elements.common.util.ExceptionMapper<?> mapper) {
            this.mapper = mapper;
        }

        private Response.Status toStatus(Exception exception) {
            Response.Status status = exception instanceof BadRequestException ? Response.Status.BAD_REQUEST : (exception instanceof NotAuthorizedException ? Response.Status.UNAUTHORIZED : (exception instanceof ForbiddenException ? Response.Status.FORBIDDEN : (exception instanceof NotFoundException ? Response.Status.NOT_FOUND : (exception instanceof NotAllowedException ? Response.Status.METHOD_NOT_ALLOWED : (exception instanceof NotAcceptableException ? Response.Status.NOT_ACCEPTABLE : (exception instanceof NotSupportedException ? Response.Status.UNSUPPORTED_MEDIA_TYPE : (exception instanceof InternalServerErrorException ? Response.Status.INTERNAL_SERVER_ERROR : (exception instanceof ServiceUnavailableException ? Response.Status.SERVICE_UNAVAILABLE : Response.Status.BAD_REQUEST))))))));
            return status;
        }

        public Response toResponse(Exception exception) {
            Object response;
            Response.Status status = this.toStatus(exception);
            if (exception instanceof InvocationException) {
                response = ((InvocationException)exception).getResponse();
            } else if (exception instanceof StatusException) {
                StatusException statusException = (StatusException)exception;
                status = statusException.getStatus();
                response = this.mapper != null ? this.mapper.toResponse(statusException.getCause()) : statusException.getCause().getMessage();
            } else {
                response = this.mapper != null ? this.mapper.toResponse((Throwable)exception) : exception.getMessage();
            }
            return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        }
    }

    private class DefaultLogEventSender
    implements LogEventSender {
        private DefaultLogEventSender() {
        }

        public void send(LogEvent event) {
            try {
                if (messageLogger.isTraceEnabled()) {
                    messageLogger.trace(this.getLogMessage(event));
                }
                if (JaxRSServer.this.logEventSender != null) {
                    JaxRSServer.this.logEventSender.send(event);
                }
            }
            catch (Exception ex) {
                logger.warn("Unable to send LogEvent", (Throwable)ex);
            }
        }

        private String getLogMessage(LogEvent event) {
            return LogMessageFormatter.format((LogEvent)event);
        }
    }
}

