/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.cxf.JaxRSServer;
import net.e6tech.elements.web.cxf.JaxResource;
import net.e6tech.elements.web.cxf.Observer;

public class JaxRSLauncher {
    private Provision provision;
    private JaxRSServer server;
    private int instanceId = 1;
    private Map<String, Object> instances = new HashMap<String, Object>();
    private Configuration.Resolver resolver = key -> this.instances.get(key);

    public static JaxRSLauncher create(ResourceManager resourceManager, String url) {
        Provision provision = (Provision)resourceManager.getInstance(Provision.class);
        return JaxRSLauncher.create(provision, url);
    }

    public static JaxRSLauncher create(Provision provision, String url) {
        JaxRSLauncher launcher = new JaxRSLauncher();
        launcher.server = (JaxRSServer)provision.newInstance(JaxRSServer.class);
        launcher.provision = provision;
        try {
            launcher.server.setAddresses(Arrays.asList(url));
            launcher.resolver(launcher.resolver);
        }
        catch (MalformedURLException e) {
            throw new SystemException((Throwable)e);
        }
        return launcher;
    }

    public Provision getProvision() {
        return this.provision;
    }

    public JaxRSServer getServer() {
        return this.server;
    }

    public JaxRSLauncher headerObserver(Observer observer) {
        this.server.setHeaderObserver(observer);
        return this;
    }

    public JaxRSLauncher resolver(Configuration.Resolver r) {
        Configuration.Resolver wrap = key -> {
            Object found = this.instances.get(key);
            if (found != null) {
                return found;
            }
            return r.resolve(key);
        };
        this.server.setResolver(wrap);
        return this;
    }

    public JaxRSLauncher add(JaxResource resource) {
        this.server.add(resource);
        return this;
    }

    public <T> JaxRSLauncher sharedService(Class<T> cls) {
        Object api = this.provision.newInstance(cls);
        this.add(new JaxResource(cls).prototype(Integer.toString(this.instanceId)).singleton());
        this.instances.put(Integer.toString(this.instanceId), api);
        ++this.instanceId;
        return this;
    }

    public <T> JaxRSLauncher perInstanceService(Class<T> cls) {
        this.add(new JaxResource(cls));
        return this;
    }

    public <T> JaxRSLauncher perInstanceService(T prototype) {
        this.add(new JaxResource(prototype.getClass()).prototype(Integer.toString(this.instanceId)));
        this.instances.put(Integer.toString(this.instanceId), prototype);
        ++this.instanceId;
        return this;
    }

    public boolean isStarted() {
        if (this.server == null) {
            return false;
        }
        return this.server.isStarted();
    }

    public JaxRSLauncher start() {
        this.provision.open().accept(Resources.class, res -> {
            this.server.initialize((Resources)res);
            this.server.start();
        });
        return this;
    }

    public JaxRSLauncher stop() {
        this.server.stop();
        return this;
    }
}

