/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.notification.ShutdownNotification;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.web.cxf.JaxRSLauncher;
import net.e6tech.elements.web.federation.AuthObserver;
import net.e6tech.elements.web.federation.Beacon;
import net.e6tech.elements.web.federation.BeaconAPI;
import net.e6tech.elements.web.federation.Event;
import net.e6tech.elements.web.federation.Member;
import net.e6tech.elements.web.federation.MemberListener;

public class Federation
implements Startable {
    protected Provision provision;
    private String hostAddress;
    private List<Member> seeds = new LinkedList<Member>();
    private Map<String, Member> hostedMembers = new HashMap<String, Member>();
    protected Beacon beacon;
    private int fanout = 5;
    private int cycle = 8;
    private int eventCacheInitialCapacity = 10;
    private long eventCacheExpire = 60000L;
    private long seedRefreshInterval = 5000L;
    private long eventInterval = 500L;
    private long syncInterval = 120000L;
    private Long renewalInterval = 10000L;
    private Long renewalPadding = 30000L;
    private int connectionTimeout = 15000;
    private int readTimeout = 10000;
    protected JaxRSLauncher launcher;
    private List<MemberListener> listeners = new LinkedList<MemberListener>();
    private AuthObserver authObserver;

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public Map<String, Member> getHostedMembers() {
        return this.hostedMembers;
    }

    public void setHostedMembers(Map<String, Member> hostedMembers) {
        this.hostedMembers = hostedMembers;
    }

    public Federation addHostedMember(String memberId, String name) {
        Member member = new Member();
        member.setName(name);
        member.setMemberId(memberId);
        this.refresh(member);
        this.hostedMembers.put(memberId, member);
        if (this.launcher != null && this.launcher.isStarted()) {
            this.beacon.announce(member);
        }
        return this;
    }

    public List<Member> getSeeds() {
        return this.seeds;
    }

    public void setSeeds(List<Member> seeds) {
        this.seeds = seeds;
    }

    public Federation addSeed(String memberId, String hostAddress) {
        Member member = new Member();
        member.setHostAddress(hostAddress);
        member.setMemberId(memberId);
        this.getSeeds().add(member);
        return this;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String address) {
        this.hostAddress = address.trim();
        while (this.hostAddress.endsWith("/")) {
            this.hostAddress = this.hostAddress.substring(0, this.hostAddress.length() - 1);
        }
    }

    public int getFanout() {
        return this.fanout;
    }

    public void setFanout(int fanout) {
        this.fanout = fanout;
    }

    public int getCycle() {
        return this.cycle;
    }

    public void setCycle(int cycle) {
        this.cycle = cycle;
    }

    public int getEventCacheInitialCapacity() {
        return this.eventCacheInitialCapacity;
    }

    public void setEventCacheInitialCapacity(int eventCacheInitialCapacity) {
        this.eventCacheInitialCapacity = eventCacheInitialCapacity;
    }

    public long getEventCacheExpire() {
        return this.eventCacheExpire;
    }

    public void setEventCacheExpire(long eventCacheExpire) {
        this.eventCacheExpire = eventCacheExpire;
    }

    public long getSeedRefreshInterval() {
        return this.seedRefreshInterval;
    }

    public void setSeedRefreshInterval(long seedRefreshInterval) {
        this.seedRefreshInterval = seedRefreshInterval;
    }

    public long getEventInterval() {
        return this.eventInterval;
    }

    public void setEventInterval(long eventInterval) {
        this.eventInterval = eventInterval;
    }

    public long getSyncInterval() {
        return this.syncInterval;
    }

    public void setSyncInterval(long syncInterval) {
        this.syncInterval = syncInterval;
    }

    public Long getRenewalInterval() {
        return this.renewalInterval;
    }

    public void setRenewalInterval(Long renewalInterval) {
        this.renewalInterval = renewalInterval;
    }

    public Long getRenewalPadding() {
        return this.renewalPadding;
    }

    public void setRenewalPadding(Long renewalPadding) {
        this.renewalPadding = renewalPadding;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Collection<Member> members() {
        return this.beacon.members();
    }

    public void onEvent(@Nonnull Event event) {
        this.beacon.onEvent(event);
    }

    public List<MemberListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<MemberListener> listeners) {
        this.listeners = listeners;
    }

    public void addListener(MemberListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MemberListener listener) {
        this.listeners.remove(listener);
    }

    public AuthObserver getAuthObserver() {
        return this.authObserver;
    }

    @Inject(optional=true)
    public void setAuthObserver(AuthObserver authObserver) {
        this.authObserver = authObserver;
    }

    protected Member refresh(Member member) {
        long duration = this.getRenewalInterval() + (long)this.getCycle() * this.getEventInterval() + this.getRenewalPadding();
        member.setExpiration(System.currentTimeMillis() + duration);
        member.setHostAddress(this.getHostAddress());
        return member;
    }

    public void start() {
        this.createServer();
        this.createServices();
        this.startServer();
        this.startServices();
        this.provision.getResourceManager().getNotificationCenter().addNotificationListener(ShutdownNotification.class, notification -> this.shutdown());
    }

    protected void createServer() {
        this.launcher = JaxRSLauncher.create(this.provision, this.hostAddress).headerObserver(this.authObserver);
    }

    protected void createServices() {
        if (this.hostAddress == null) {
            throw new IllegalStateException("hostAddress is null.");
        }
        if (this.cycle <= 0) {
            throw new IllegalStateException("cycle needs to be greater than 0.");
        }
        if (this.fanout <= 0) {
            throw new IllegalStateException("fanout needs to be greater than 0.");
        }
        this.hostedMembers.forEach((id, m) -> {
            if (m.getMemberId() == null) {
                throw new IllegalStateException("memberId is null.");
            }
            if (m.getName() == null) {
                throw new IllegalStateException("member name is null.");
            }
            if (!m.getMemberId().equals(id)) {
                throw new IllegalStateException("memberId does not match hostedMembers' key");
            }
            this.refresh((Member)m);
        });
        this.beacon = new Beacon();
        this.beacon.setFederation(this);
        this.beacon.seeds(this.seeds);
        this.provision.inject((Object)this.beacon);
        BeaconAPI prototype = new BeaconAPI();
        prototype.setFederation(this);
        this.perInstanceService(prototype);
    }

    protected <T> void sharedService(Class<T> cls) {
        this.launcher.sharedService(cls);
    }

    protected <T> void perInstanceService(Class<T> cls) {
        this.launcher.perInstanceService(cls);
    }

    protected <T> void perInstanceService(T prototype) {
        this.launcher.perInstanceService(prototype);
    }

    protected void startServer() {
        this.launcher.start();
    }

    protected void startServices() {
        this.beacon.start();
    }

    public void shutdown() {
        this.beacon.shutdown();
        this.launcher.stop();
    }
}

