/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.federation;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.web.federation.Event;
import net.e6tech.elements.web.federation.Federation;
import net.e6tech.elements.web.federation.Member;

@Path(value="/v1/beacon")
public class BeaconAPI {
    @Inject
    private Provision provision;
    private Federation federation;

    public Federation getFederation() {
        return this.federation;
    }

    public void setFederation(Federation federation) {
        this.federation = federation;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="hosts")
    public Collection<Member> hosts() {
        return this.federation.getHostedMembers().values();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="members")
    public Collection<Member> members() {
        return this.federation.members();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="events")
    public void onEvent(@Nonnull Event event) {
        this.federation.onEvent(event);
    }
}

