/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf.tomcat;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.servlet.Servlet;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.JaxRSServlet;
import net.e6tech.elements.web.cxf.ServerController;
import net.e6tech.elements.web.cxf.ServerEngine;
import net.e6tech.elements.web.cxf.tomcat.TomcatActorExecutor;
import net.e6tech.elements.web.cxf.tomcat.TomcatSSL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;

public class TomcatEngine
implements ServerEngine {
    private static Logger logger = Logger.getLogger();
    private int maxThreads = 250;
    private int minSpareThreads = 10;
    private int maxConnections = 10000;
    private String baseDir;
    private Provision provision;
    private boolean useActorThreadPool = false;
    private WorkerPoolConfig workerPoolConfig = new WorkerPoolConfig();
    private TomcatSSL tomcatSSL = new TomcatSSL();

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject(optional=true)
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public WorkerPoolConfig getWorkerPoolConfig() {
        return this.workerPoolConfig;
    }

    @Inject(optional=true)
    public void setWorkerPoolConfig(WorkerPoolConfig workerPoolConfig) {
        this.workerPoolConfig = workerPoolConfig;
    }

    public boolean isUseActorThreadPool() {
        return this.useActorThreadPool;
    }

    public void setUseActorThreadPool(boolean useActorThreadPool) {
        this.useActorThreadPool = useActorThreadPool;
    }

    public TomcatSSL getTomcatSSL() {
        return this.tomcatSSL;
    }

    @Inject(optional=true)
    public void setTomcatSSL(TomcatSSL tomcatSSL) {
        this.tomcatSSL = tomcatSSL;
    }

    @Override
    public void start(CXFServer cxfServer, ServerController<?> controller) {
        List tomcats = cxfServer.computeServerEngineData(LinkedList::new);
        Tomcat tomcat = new Tomcat();
        tomcats.add(tomcat);
        tomcat.setHostname(controller.getURL().getHost());
        if (this.baseDir != null) {
            tomcat.setBaseDir(this.baseDir + "." + controller.getURL().getPort());
        }
        JaxRSServlet servlet = new JaxRSServlet((JAXRSServerFactoryBean)controller.getFactory());
        String context = controller.getURL().getPath();
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 1);
        }
        Context ctx = tomcat.addContext(context, null);
        tomcat.addServlet(context, "jaxrs", (Servlet)servlet);
        ctx.addServletMappingDecoded("/*", "jaxrs");
        try {
            Connector connector = this.createConnector(cxfServer, controller.getURL());
            if (this.provision != null && this.useActorThreadPool) {
                TomcatActorExecutor executor = (TomcatActorExecutor)this.provision.newInstance(TomcatActorExecutor.class);
                executor.setWorkerPoolConfig(this.getWorkerPoolConfig());
                executor.start();
                connector.getProtocolHandler().setExecutor((Executor)executor);
            }
            connector.setPort(controller.getURL().getPort());
            tomcat.setConnector(connector);
            tomcat.start();
        }
        catch (LifecycleException e) {
            throw new SystemException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(CXFServer cxfServer) {
        List tomcats = cxfServer.computeServerEngineData(LinkedList::new);
        Iterator iterator = tomcats.iterator();
        while (iterator.hasNext()) {
            Tomcat tomcat = (Tomcat)iterator.next();
            Executor executor = null;
            try {
                executor = tomcat.getConnector().getProtocolHandler().getExecutor();
                tomcat.stop();
                tomcat.destroy();
            }
            catch (Exception ex) {
                StringBuilder builder = new StringBuilder();
                for (Container container : tomcat.getHost().findChildren()) {
                    if (!(container instanceof Context)) continue;
                    builder.append(" " + ((Context)container).getPath());
                }
                logger.warn("Cannot stop Tomcat for path{} - {}: {}", new Object[]{builder, ex.getMessage(), ex.getCause().getMessage()});
            }
            finally {
                if (executor instanceof TomcatActorExecutor) {
                    ((TomcatActorExecutor)executor).stop();
                }
            }
            iterator.remove();
        }
    }

    protected Connector createConnector(CXFServer cxfServer, URL url) {
        Connector connector = this.tomcatSSL.createConnector();
        connector.setPort(url.getPort());
        connector.setAttribute("maxThreads", (Object)this.maxThreads);
        connector.setAttribute("maxConnections", (Object)this.maxConnections);
        connector.setAttribute("minSpareThreads", (Object)this.minSpareThreads);
        connector.setAttribute("address", (Object)url.getHost());
        this.tomcatSSL.initialize(cxfServer, url, connector);
        return connector;
    }
}

